// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Provisioning status of the managed application. </summary>
    public readonly partial struct ResourcesProvisioningState : IEquatable<ResourcesProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourcesProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourcesProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string AcceptedValue = "Accepted";
        private const string RunningValue = "Running";
        private const string ReadyValue = "Ready";
        private const string CreatingValue = "Creating";
        private const string CreatedValue = "Created";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";

        /// <summary> NotSpecified. </summary>
        public static ResourcesProvisioningState NotSpecified { get; } = new ResourcesProvisioningState(NotSpecifiedValue);
        /// <summary> Accepted. </summary>
        public static ResourcesProvisioningState Accepted { get; } = new ResourcesProvisioningState(AcceptedValue);
        /// <summary> Running. </summary>
        public static ResourcesProvisioningState Running { get; } = new ResourcesProvisioningState(RunningValue);
        /// <summary> Ready. </summary>
        public static ResourcesProvisioningState Ready { get; } = new ResourcesProvisioningState(ReadyValue);
        /// <summary> Creating. </summary>
        public static ResourcesProvisioningState Creating { get; } = new ResourcesProvisioningState(CreatingValue);
        /// <summary> Created. </summary>
        public static ResourcesProvisioningState Created { get; } = new ResourcesProvisioningState(CreatedValue);
        /// <summary> Deleting. </summary>
        public static ResourcesProvisioningState Deleting { get; } = new ResourcesProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static ResourcesProvisioningState Deleted { get; } = new ResourcesProvisioningState(DeletedValue);
        /// <summary> Canceled. </summary>
        public static ResourcesProvisioningState Canceled { get; } = new ResourcesProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static ResourcesProvisioningState Failed { get; } = new ResourcesProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static ResourcesProvisioningState Succeeded { get; } = new ResourcesProvisioningState(SucceededValue);
        /// <summary> Updating. </summary>
        public static ResourcesProvisioningState Updating { get; } = new ResourcesProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="ResourcesProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ResourcesProvisioningState left, ResourcesProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourcesProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ResourcesProvisioningState left, ResourcesProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourcesProvisioningState"/>. </summary>
        public static implicit operator ResourcesProvisioningState(string value) => new ResourcesProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourcesProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourcesProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
