// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The resourceId extended model. This is used to document failed resources with a resourceId and a corresponding error. </summary>
    public partial class ResourceReferenceExtended : ResourceReferenceAutoGenerated
    {
        /// <summary> Initializes a new instance of <see cref="ResourceReferenceExtended"/>. </summary>
        public ResourceReferenceExtended()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceReferenceExtended"/>. </summary>
        /// <param name="id"> The resourceId of a resource managed by the deployment stack. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="error"> The error detail. </param>
        internal ResourceReferenceExtended(string id, IDictionary<string, BinaryData> serializedAdditionalRawData, ResponseError error) : base(id, serializedAdditionalRawData)
        {
            Error = error;
        }

        /// <summary> The error detail. </summary>
        [WirePath("error")]
        public ResponseError Error { get; set; }
    }
}
