// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Resources.Models
{
    internal static partial class ProvisioningOperationKindExtensions
    {
        public static string ToSerialString(this ProvisioningOperationKind value) => value switch
        {
            ProvisioningOperationKind.NotSpecified => "NotSpecified",
            ProvisioningOperationKind.Create => "Create",
            ProvisioningOperationKind.Delete => "Delete",
            ProvisioningOperationKind.Waiting => "Waiting",
            ProvisioningOperationKind.AzureAsyncOperationWaiting => "AzureAsyncOperationWaiting",
            ProvisioningOperationKind.ResourceCacheWaiting => "ResourceCacheWaiting",
            ProvisioningOperationKind.Action => "Action",
            ProvisioningOperationKind.Read => "Read",
            ProvisioningOperationKind.EvaluateDeploymentOutput => "EvaluateDeploymentOutput",
            ProvisioningOperationKind.DeploymentCleanup => "DeploymentCleanup",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ProvisioningOperationKind value.")
        };

        public static ProvisioningOperationKind ToProvisioningOperationKind(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSpecified")) return ProvisioningOperationKind.NotSpecified;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Create")) return ProvisioningOperationKind.Create;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Delete")) return ProvisioningOperationKind.Delete;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Waiting")) return ProvisioningOperationKind.Waiting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureAsyncOperationWaiting")) return ProvisioningOperationKind.AzureAsyncOperationWaiting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ResourceCacheWaiting")) return ProvisioningOperationKind.ResourceCacheWaiting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Action")) return ProvisioningOperationKind.Action;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Read")) return ProvisioningOperationKind.Read;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "EvaluateDeploymentOutput")) return ProvisioningOperationKind.EvaluateDeploymentOutput;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DeploymentCleanup")) return ProvisioningOperationKind.DeploymentCleanup;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ProvisioningOperationKind value.");
        }
    }
}
