// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The managed resource model. </summary>
    public partial class ManagedResourceReference : ResourceReferenceAutoGenerated
    {
        /// <summary> Initializes a new instance of <see cref="ManagedResourceReference"/>. </summary>
        public ManagedResourceReference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagedResourceReference"/>. </summary>
        /// <param name="id"> The resourceId of a resource managed by the deployment stack. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="status"> Current management state of the resource in the deployment stack. </param>
        /// <param name="denyStatus"> denyAssignment settings applied to the resource. </param>
        internal ManagedResourceReference(string id, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceStatusMode? status, DenyStatusMode? denyStatus) : base(id, serializedAdditionalRawData)
        {
            Status = status;
            DenyStatus = denyStatus;
        }

        /// <summary> Current management state of the resource in the deployment stack. </summary>
        [WirePath("status")]
        public ResourceStatusMode? Status { get; set; }
        /// <summary> denyAssignment settings applied to the resource. </summary>
        [WirePath("denyStatus")]
        public DenyStatusMode? DenyStatus { get; set; }
    }
}
