// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The JIT scheduling policies. </summary>
    public partial class JitSchedulingPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="JitSchedulingPolicy"/>. </summary>
        /// <param name="schedulingType"> The type of JIT schedule. </param>
        /// <param name="duration"> The required duration of the JIT request. </param>
        /// <param name="startOn"> The start time of the request. </param>
        public JitSchedulingPolicy(JitSchedulingType schedulingType, TimeSpan duration, DateTimeOffset startOn)
        {
            SchedulingType = schedulingType;
            Duration = duration;
            StartOn = startOn;
        }

        /// <summary> Initializes a new instance of <see cref="JitSchedulingPolicy"/>. </summary>
        /// <param name="schedulingType"> The type of JIT schedule. </param>
        /// <param name="duration"> The required duration of the JIT request. </param>
        /// <param name="startOn"> The start time of the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal JitSchedulingPolicy(JitSchedulingType schedulingType, TimeSpan duration, DateTimeOffset startOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SchedulingType = schedulingType;
            Duration = duration;
            StartOn = startOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="JitSchedulingPolicy"/> for deserialization. </summary>
        internal JitSchedulingPolicy()
        {
        }

        /// <summary> The type of JIT schedule. </summary>
        [WirePath("type")]
        public JitSchedulingType SchedulingType { get; }
        /// <summary> The required duration of the JIT request. </summary>
        [WirePath("duration")]
        public TimeSpan Duration { get; set; }
        /// <summary> The start time of the request. </summary>
        [WirePath("startTime")]
        public DateTimeOffset StartOn { get; set; }
    }
}
