// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The JIT request state. </summary>
    public readonly partial struct JitRequestState : IEquatable<JitRequestState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JitRequestState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JitRequestState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string DeniedValue = "Denied";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ExpiredValue = "Expired";
        private const string TimeoutValue = "Timeout";

        /// <summary> NotSpecified. </summary>
        public static JitRequestState NotSpecified { get; } = new JitRequestState(NotSpecifiedValue);
        /// <summary> Pending. </summary>
        public static JitRequestState Pending { get; } = new JitRequestState(PendingValue);
        /// <summary> Approved. </summary>
        public static JitRequestState Approved { get; } = new JitRequestState(ApprovedValue);
        /// <summary> Denied. </summary>
        public static JitRequestState Denied { get; } = new JitRequestState(DeniedValue);
        /// <summary> Failed. </summary>
        public static JitRequestState Failed { get; } = new JitRequestState(FailedValue);
        /// <summary> Canceled. </summary>
        public static JitRequestState Canceled { get; } = new JitRequestState(CanceledValue);
        /// <summary> Expired. </summary>
        public static JitRequestState Expired { get; } = new JitRequestState(ExpiredValue);
        /// <summary> Timeout. </summary>
        public static JitRequestState Timeout { get; } = new JitRequestState(TimeoutValue);
        /// <summary> Determines if two <see cref="JitRequestState"/> values are the same. </summary>
        public static bool operator ==(JitRequestState left, JitRequestState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JitRequestState"/> values are not the same. </summary>
        public static bool operator !=(JitRequestState left, JitRequestState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JitRequestState"/>. </summary>
        public static implicit operator JitRequestState(string value) => new JitRequestState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JitRequestState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JitRequestState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
