// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The JIT authorization policies. </summary>
    public partial class JitAuthorizationPolicies
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="JitAuthorizationPolicies"/>. </summary>
        /// <param name="principalId"> The the principal id that will be granted JIT access. </param>
        /// <param name="roleDefinitionId"> The role definition id that will be granted to the Principal. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionId"/> is null. </exception>
        public JitAuthorizationPolicies(Guid principalId, string roleDefinitionId)
        {
            Argument.AssertNotNull(roleDefinitionId, nameof(roleDefinitionId));

            PrincipalId = principalId;
            RoleDefinitionId = roleDefinitionId;
        }

        /// <summary> Initializes a new instance of <see cref="JitAuthorizationPolicies"/>. </summary>
        /// <param name="principalId"> The the principal id that will be granted JIT access. </param>
        /// <param name="roleDefinitionId"> The role definition id that will be granted to the Principal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal JitAuthorizationPolicies(Guid principalId, string roleDefinitionId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrincipalId = principalId;
            RoleDefinitionId = roleDefinitionId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="JitAuthorizationPolicies"/> for deserialization. </summary>
        internal JitAuthorizationPolicies()
        {
        }

        /// <summary> The the principal id that will be granted JIT access. </summary>
        [WirePath("principalId")]
        public Guid PrincipalId { get; set; }
        /// <summary> The role definition id that will be granted to the Principal. </summary>
        [WirePath("roleDefinitionId")]
        public string RoleDefinitionId { get; set; }
    }
}
