// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The approver type. </summary>
    public readonly partial struct JitApproverType : IEquatable<JitApproverType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JitApproverType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JitApproverType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserValue = "user";
        private const string GroupValue = "group";

        /// <summary> user. </summary>
        public static JitApproverType User { get; } = new JitApproverType(UserValue);
        /// <summary> group. </summary>
        public static JitApproverType Group { get; } = new JitApproverType(GroupValue);
        /// <summary> Determines if two <see cref="JitApproverType"/> values are the same. </summary>
        public static bool operator ==(JitApproverType left, JitApproverType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JitApproverType"/> values are not the same. </summary>
        public static bool operator !=(JitApproverType left, JitApproverType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JitApproverType"/>. </summary>
        public static implicit operator JitApproverType(string value) => new JitApproverType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JitApproverType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JitApproverType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
