// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The scope to be used for evaluation of parameters, variables and functions in a nested template. </summary>
    public readonly partial struct ExpressionEvaluationScope : IEquatable<ExpressionEvaluationScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressionEvaluationScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressionEvaluationScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string OuterValue = "Outer";
        private const string InnerValue = "Inner";

        /// <summary> NotSpecified. </summary>
        public static ExpressionEvaluationScope NotSpecified { get; } = new ExpressionEvaluationScope(NotSpecifiedValue);
        /// <summary> Outer. </summary>
        public static ExpressionEvaluationScope Outer { get; } = new ExpressionEvaluationScope(OuterValue);
        /// <summary> Inner. </summary>
        public static ExpressionEvaluationScope Inner { get; } = new ExpressionEvaluationScope(InnerValue);
        /// <summary> Determines if two <see cref="ExpressionEvaluationScope"/> values are the same. </summary>
        public static bool operator ==(ExpressionEvaluationScope left, ExpressionEvaluationScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressionEvaluationScope"/> values are not the same. </summary>
        public static bool operator !=(ExpressionEvaluationScope left, ExpressionEvaluationScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressionEvaluationScope"/>. </summary>
        public static implicit operator ExpressionEvaluationScope(string value) => new ExpressionEvaluationScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressionEvaluationScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressionEvaluationScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
