// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> denySettings Mode that defines denied actions. </summary>
    public readonly partial struct DenySettingsMode : IEquatable<DenySettingsMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DenySettingsMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DenySettingsMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DenyDeleteValue = "denyDelete";
        private const string DenyWriteAndDeleteValue = "denyWriteAndDelete";
        private const string NoneValue = "none";

        /// <summary> Authorized users are able to read and modify the resources, but cannot delete. </summary>
        public static DenySettingsMode DenyDelete { get; } = new DenySettingsMode(DenyDeleteValue);
        /// <summary> Authorized users can read from a resource, but cannot modify or delete it. </summary>
        public static DenySettingsMode DenyWriteAndDelete { get; } = new DenySettingsMode(DenyWriteAndDeleteValue);
        /// <summary> No denyAssignments have been applied. </summary>
        public static DenySettingsMode None { get; } = new DenySettingsMode(NoneValue);
        /// <summary> Determines if two <see cref="DenySettingsMode"/> values are the same. </summary>
        public static bool operator ==(DenySettingsMode left, DenySettingsMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DenySettingsMode"/> values are not the same. </summary>
        public static bool operator !=(DenySettingsMode left, DenySettingsMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DenySettingsMode"/>. </summary>
        public static implicit operator DenySettingsMode(string value) => new DenySettingsMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DenySettingsMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DenySettingsMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
