// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Defines how resources deployed by the Deployment stack are locked. </summary>
    public partial class DenySettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DenySettings"/>. </summary>
        /// <param name="mode"> denySettings Mode that defines denied actions. </param>
        public DenySettings(DenySettingsMode mode)
        {
            Mode = mode;
            ExcludedPrincipals = new ChangeTrackingList<string>();
            ExcludedActions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DenySettings"/>. </summary>
        /// <param name="mode"> denySettings Mode that defines denied actions. </param>
        /// <param name="excludedPrincipals"> List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted. </param>
        /// <param name="excludedActions"> List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*\/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed. </param>
        /// <param name="applyToChildScopes"> DenySettings will be applied to child resource scopes of every managed resource with a deny assignment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DenySettings(DenySettingsMode mode, IList<string> excludedPrincipals, IList<string> excludedActions, bool? applyToChildScopes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Mode = mode;
            ExcludedPrincipals = excludedPrincipals;
            ExcludedActions = excludedActions;
            ApplyToChildScopes = applyToChildScopes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DenySettings"/> for deserialization. </summary>
        internal DenySettings()
        {
        }

        /// <summary> denySettings Mode that defines denied actions. </summary>
        [WirePath("mode")]
        public DenySettingsMode Mode { get; set; }
        /// <summary> List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted. </summary>
        [WirePath("excludedPrincipals")]
        public IList<string> ExcludedPrincipals { get; }
        /// <summary> List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*\/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed. </summary>
        [WirePath("excludedActions")]
        public IList<string> ExcludedActions { get; }
        /// <summary> DenySettings will be applied to child resource scopes of every managed resource with a deny assignment. </summary>
        [WirePath("applyToChildScopes")]
        public bool? ApplyToChildScopes { get; set; }
    }
}
