// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Resources.Models
{
    public partial class DecompileOperationSuccessResult : IUtf8JsonSerializable, IJsonModel<DecompileOperationSuccessResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DecompileOperationSuccessResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DecompileOperationSuccessResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DecompileOperationSuccessResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DecompileOperationSuccessResult)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("files"u8);
            writer.WriteStartArray();
            foreach (var item in Files)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("entryPoint"u8);
            writer.WriteStringValue(EntryPoint);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DecompileOperationSuccessResult IJsonModel<DecompileOperationSuccessResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DecompileOperationSuccessResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DecompileOperationSuccessResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDecompileOperationSuccessResult(document.RootElement, options);
        }

        internal static DecompileOperationSuccessResult DeserializeDecompileOperationSuccessResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<DecompiledFileDefinition> files = default;
            string entryPoint = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("files"u8))
                {
                    List<DecompiledFileDefinition> array = new List<DecompiledFileDefinition>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DecompiledFileDefinition.DeserializeDecompiledFileDefinition(item, options));
                    }
                    files = array;
                    continue;
                }
                if (property.NameEquals("entryPoint"u8))
                {
                    entryPoint = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DecompileOperationSuccessResult(files, entryPoint, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Files), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  files: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Files))
                {
                    if (Files.Any())
                    {
                        builder.Append("  files: ");
                        builder.AppendLine("[");
                        foreach (var item in Files)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  files: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EntryPoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  entryPoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EntryPoint))
                {
                    builder.Append("  entryPoint: ");
                    if (EntryPoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EntryPoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EntryPoint}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DecompileOperationSuccessResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DecompileOperationSuccessResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DecompileOperationSuccessResult)} does not support writing '{options.Format}' format.");
            }
        }

        DecompileOperationSuccessResult IPersistableModel<DecompileOperationSuccessResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DecompileOperationSuccessResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDecompileOperationSuccessResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DecompileOperationSuccessResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DecompileOperationSuccessResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
