// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The body of the request for the decompileBicep operation. </summary>
    public partial class DecompileOperationContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DecompileOperationContent"/>. </summary>
        /// <param name="template"> The ARM json template to be decompiled into a Bicep file. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="template"/> is null. </exception>
        public DecompileOperationContent(string template)
        {
            Argument.AssertNotNull(template, nameof(template));

            Template = template;
        }

        /// <summary> Initializes a new instance of <see cref="DecompileOperationContent"/>. </summary>
        /// <param name="template"> The ARM json template to be decompiled into a Bicep file. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DecompileOperationContent(string template, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Template = template;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DecompileOperationContent"/> for deserialization. </summary>
        internal DecompileOperationContent()
        {
        }

        /// <summary> The ARM json template to be decompiled into a Bicep file. </summary>
        [WirePath("template")]
        public string Template { get; }
    }
}
