// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Denotes the state of provisioning. </summary>
    public readonly partial struct DataBoundaryProvisioningState : IEquatable<DataBoundaryProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoundaryProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoundaryProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string RunningValue = "Running";
        private const string CreatingValue = "Creating";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";

        /// <summary> Accepted. </summary>
        public static DataBoundaryProvisioningState Accepted { get; } = new DataBoundaryProvisioningState(AcceptedValue);
        /// <summary> Running. </summary>
        public static DataBoundaryProvisioningState Running { get; } = new DataBoundaryProvisioningState(RunningValue);
        /// <summary> Creating. </summary>
        public static DataBoundaryProvisioningState Creating { get; } = new DataBoundaryProvisioningState(CreatingValue);
        /// <summary> Canceled. </summary>
        public static DataBoundaryProvisioningState Canceled { get; } = new DataBoundaryProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static DataBoundaryProvisioningState Failed { get; } = new DataBoundaryProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static DataBoundaryProvisioningState Succeeded { get; } = new DataBoundaryProvisioningState(SucceededValue);
        /// <summary> Updating. </summary>
        public static DataBoundaryProvisioningState Updating { get; } = new DataBoundaryProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="DataBoundaryProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DataBoundaryProvisioningState left, DataBoundaryProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoundaryProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DataBoundaryProvisioningState left, DataBoundaryProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoundaryProvisioningState"/>. </summary>
        public static implicit operator DataBoundaryProvisioningState(string value) => new DataBoundaryProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoundaryProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoundaryProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
