// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> SKU for the resource. </summary>
    public partial class ArmApplicationSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArmApplicationSku"/>. </summary>
        /// <param name="name"> The SKU name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public ArmApplicationSku(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationSku"/>. </summary>
        /// <param name="name"> The SKU name. </param>
        /// <param name="tier"> The SKU tier. </param>
        /// <param name="size"> The SKU size. </param>
        /// <param name="family"> The SKU family. </param>
        /// <param name="model"> The SKU model. </param>
        /// <param name="capacity"> The SKU capacity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArmApplicationSku(string name, string tier, string size, string family, string model, int? capacity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Tier = tier;
            Size = size;
            Family = family;
            Model = model;
            Capacity = capacity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationSku"/> for deserialization. </summary>
        internal ArmApplicationSku()
        {
        }

        /// <summary> The SKU name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The SKU tier. </summary>
        [WirePath("tier")]
        public string Tier { get; set; }
        /// <summary> The SKU size. </summary>
        [WirePath("size")]
        public string Size { get; set; }
        /// <summary> The SKU family. </summary>
        [WirePath("family")]
        public string Family { get; set; }
        /// <summary> The SKU model. </summary>
        [WirePath("model")]
        public string Model { get; set; }
        /// <summary> The SKU capacity. </summary>
        [WirePath("capacity")]
        public int? Capacity { get; set; }
    }
}
