// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Managed application policy. </summary>
    public partial class ArmApplicationPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArmApplicationPolicy"/>. </summary>
        public ArmApplicationPolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationPolicy"/>. </summary>
        /// <param name="name"> The policy name. </param>
        /// <param name="policyDefinitionId"> The policy definition Id. </param>
        /// <param name="parameters"> The policy parameters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArmApplicationPolicy(string name, string policyDefinitionId, string parameters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            PolicyDefinitionId = policyDefinitionId;
            Parameters = parameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The policy name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The policy definition Id. </summary>
        [WirePath("policyDefinitionId")]
        public string PolicyDefinitionId { get; set; }
        /// <summary> The policy parameters. </summary>
        [WirePath("parameters")]
        public string Parameters { get; set; }
    }
}
