// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The management mode. </summary>
    public readonly partial struct ArmApplicationManagementMode : IEquatable<ArmApplicationManagementMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArmApplicationManagementMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArmApplicationManagementMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string UnmanagedValue = "Unmanaged";
        private const string ManagedValue = "Managed";

        /// <summary> NotSpecified. </summary>
        public static ArmApplicationManagementMode NotSpecified { get; } = new ArmApplicationManagementMode(NotSpecifiedValue);
        /// <summary> Unmanaged. </summary>
        public static ArmApplicationManagementMode Unmanaged { get; } = new ArmApplicationManagementMode(UnmanagedValue);
        /// <summary> Managed. </summary>
        public static ArmApplicationManagementMode Managed { get; } = new ArmApplicationManagementMode(ManagedValue);
        /// <summary> Determines if two <see cref="ArmApplicationManagementMode"/> values are the same. </summary>
        public static bool operator ==(ArmApplicationManagementMode left, ArmApplicationManagementMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArmApplicationManagementMode"/> values are not the same. </summary>
        public static bool operator !=(ArmApplicationManagementMode left, ArmApplicationManagementMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArmApplicationManagementMode"/>. </summary>
        public static implicit operator ArmApplicationManagementMode(string value) => new ArmApplicationManagementMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArmApplicationManagementMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArmApplicationManagementMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
