// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Resources.Models
{
    internal static partial class ArmApplicationManagedIdentityTypeExtensions
    {
        public static string ToSerialString(this ArmApplicationManagedIdentityType value) => value switch
        {
            ArmApplicationManagedIdentityType.None => "None",
            ArmApplicationManagedIdentityType.SystemAssigned => "SystemAssigned",
            ArmApplicationManagedIdentityType.UserAssigned => "UserAssigned",
            ArmApplicationManagedIdentityType.SystemAssignedUserAssigned => "SystemAssigned, UserAssigned",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArmApplicationManagedIdentityType value.")
        };

        public static ArmApplicationManagedIdentityType ToArmApplicationManagedIdentityType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return ArmApplicationManagedIdentityType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SystemAssigned")) return ArmApplicationManagedIdentityType.SystemAssigned;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UserAssigned")) return ArmApplicationManagedIdentityType.UserAssigned;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SystemAssigned, UserAssigned")) return ArmApplicationManagedIdentityType.SystemAssignedUserAssigned;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArmApplicationManagedIdentityType value.");
        }
    }
}
