// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Resources.Models
{
    internal static partial class ArmApplicationLockLevelExtensions
    {
        public static string ToSerialString(this ArmApplicationLockLevel value) => value switch
        {
            ArmApplicationLockLevel.None => "None",
            ArmApplicationLockLevel.CanNotDelete => "CanNotDelete",
            ArmApplicationLockLevel.ReadOnly => "ReadOnly",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArmApplicationLockLevel value.")
        };

        public static ArmApplicationLockLevel ToArmApplicationLockLevel(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return ArmApplicationLockLevel.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CanNotDelete")) return ArmApplicationLockLevel.CanNotDelete;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ReadOnly")) return ArmApplicationLockLevel.ReadOnly;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArmApplicationLockLevel value.");
        }
    }
}
