// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The application client details to track the entity creating/updating the managed app resource. </summary>
    public partial class ArmApplicationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDetails"/>. </summary>
        internal ArmApplicationDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDetails"/>. </summary>
        /// <param name="objectId"> The client Oid. </param>
        /// <param name="puid"> The client Puid. </param>
        /// <param name="applicationId"> The client application Id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArmApplicationDetails(Guid? objectId, string puid, Guid? applicationId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ObjectId = objectId;
            Puid = puid;
            ApplicationId = applicationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The client Oid. </summary>
        [WirePath("oid")]
        public Guid? ObjectId { get; }
        /// <summary> The client Puid. </summary>
        [WirePath("puid")]
        public string Puid { get; }
        /// <summary> The client application Id. </summary>
        [WirePath("applicationId")]
        public Guid? ApplicationId { get; }
    }
}
