// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Managed application deployment policy. </summary>
    internal partial class ArmApplicationDeploymentPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDeploymentPolicy"/>. </summary>
        /// <param name="deploymentMode"> The managed application deployment mode. </param>
        public ArmApplicationDeploymentPolicy(ArmApplicationDeploymentMode deploymentMode)
        {
            DeploymentMode = deploymentMode;
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDeploymentPolicy"/>. </summary>
        /// <param name="deploymentMode"> The managed application deployment mode. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArmApplicationDeploymentPolicy(ArmApplicationDeploymentMode deploymentMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeploymentMode = deploymentMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDeploymentPolicy"/> for deserialization. </summary>
        internal ArmApplicationDeploymentPolicy()
        {
        }

        /// <summary> The managed application deployment mode. </summary>
        [WirePath("deploymentMode")]
        public ArmApplicationDeploymentMode DeploymentMode { get; set; }
    }
}
