// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The deployment mode. </summary>
    public readonly partial struct ArmApplicationDeploymentMode : IEquatable<ArmApplicationDeploymentMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDeploymentMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArmApplicationDeploymentMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string IncrementalValue = "Incremental";
        private const string CompleteValue = "Complete";

        /// <summary> NotSpecified. </summary>
        public static ArmApplicationDeploymentMode NotSpecified { get; } = new ArmApplicationDeploymentMode(NotSpecifiedValue);
        /// <summary> Incremental. </summary>
        public static ArmApplicationDeploymentMode Incremental { get; } = new ArmApplicationDeploymentMode(IncrementalValue);
        /// <summary> Complete. </summary>
        public static ArmApplicationDeploymentMode Complete { get; } = new ArmApplicationDeploymentMode(CompleteValue);
        /// <summary> Determines if two <see cref="ArmApplicationDeploymentMode"/> values are the same. </summary>
        public static bool operator ==(ArmApplicationDeploymentMode left, ArmApplicationDeploymentMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArmApplicationDeploymentMode"/> values are not the same. </summary>
        public static bool operator !=(ArmApplicationDeploymentMode left, ArmApplicationDeploymentMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArmApplicationDeploymentMode"/>. </summary>
        public static implicit operator ArmApplicationDeploymentMode(string value) => new ArmApplicationDeploymentMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArmApplicationDeploymentMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArmApplicationDeploymentMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
