// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The managed application artifact name. </summary>
    public readonly partial struct ArmApplicationArtifactName : IEquatable<ArmApplicationArtifactName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArmApplicationArtifactName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArmApplicationArtifactName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string ViewDefinitionValue = "ViewDefinition";
        private const string AuthorizationsValue = "Authorizations";
        private const string CustomRoleDefinitionValue = "CustomRoleDefinition";

        /// <summary> NotSpecified. </summary>
        public static ArmApplicationArtifactName NotSpecified { get; } = new ArmApplicationArtifactName(NotSpecifiedValue);
        /// <summary> ViewDefinition. </summary>
        public static ArmApplicationArtifactName ViewDefinition { get; } = new ArmApplicationArtifactName(ViewDefinitionValue);
        /// <summary> Authorizations. </summary>
        public static ArmApplicationArtifactName Authorizations { get; } = new ArmApplicationArtifactName(AuthorizationsValue);
        /// <summary> CustomRoleDefinition. </summary>
        public static ArmApplicationArtifactName CustomRoleDefinition { get; } = new ArmApplicationArtifactName(CustomRoleDefinitionValue);
        /// <summary> Determines if two <see cref="ArmApplicationArtifactName"/> values are the same. </summary>
        public static bool operator ==(ArmApplicationArtifactName left, ArmApplicationArtifactName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArmApplicationArtifactName"/> values are not the same. </summary>
        public static bool operator !=(ArmApplicationArtifactName left, ArmApplicationArtifactName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArmApplicationArtifactName"/>. </summary>
        public static implicit operator ArmApplicationArtifactName(string value) => new ArmApplicationArtifactName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArmApplicationArtifactName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArmApplicationArtifactName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
