// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Resources.Models
{
    public partial class ActionOnUnmanage : IUtf8JsonSerializable, IJsonModel<ActionOnUnmanage>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ActionOnUnmanage>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ActionOnUnmanage>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ActionOnUnmanage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ActionOnUnmanage)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("resources"u8);
            writer.WriteStringValue(Resources.ToString());
            if (Optional.IsDefined(ResourceGroups))
            {
                writer.WritePropertyName("resourceGroups"u8);
                writer.WriteStringValue(ResourceGroups.Value.ToString());
            }
            if (Optional.IsDefined(ManagementGroups))
            {
                writer.WritePropertyName("managementGroups"u8);
                writer.WriteStringValue(ManagementGroups.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ActionOnUnmanage IJsonModel<ActionOnUnmanage>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ActionOnUnmanage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ActionOnUnmanage)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeActionOnUnmanage(document.RootElement, options);
        }

        internal static ActionOnUnmanage DeserializeActionOnUnmanage(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DeploymentStacksDeleteDetachEnum resources = default;
            DeploymentStacksDeleteDetachEnum? resourceGroups = default;
            DeploymentStacksDeleteDetachEnum? managementGroups = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resources"u8))
                {
                    resources = new DeploymentStacksDeleteDetachEnum(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resourceGroups"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resourceGroups = new DeploymentStacksDeleteDetachEnum(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("managementGroups"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    managementGroups = new DeploymentStacksDeleteDetachEnum(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ActionOnUnmanage(resources, resourceGroups, managementGroups, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Resources), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  resources: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  resources: ");
                builder.AppendLine($"'{Resources.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceGroups), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  resourceGroups: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResourceGroups))
                {
                    builder.Append("  resourceGroups: ");
                    builder.AppendLine($"'{ResourceGroups.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ManagementGroups), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  managementGroups: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ManagementGroups))
                {
                    builder.Append("  managementGroups: ");
                    builder.AppendLine($"'{ManagementGroups.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ActionOnUnmanage>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ActionOnUnmanage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ActionOnUnmanage)} does not support writing '{options.Format}' format.");
            }
        }

        ActionOnUnmanage IPersistableModel<ActionOnUnmanage>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ActionOnUnmanage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeActionOnUnmanage(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ActionOnUnmanage)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ActionOnUnmanage>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
