// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Resources
{
    internal class JitRequestOperationSource : IOperationSource<JitRequestResource>
    {
        private readonly ArmClient _client;

        internal JitRequestOperationSource(ArmClient client)
        {
            _client = client;
        }

        JitRequestResource IOperationSource<JitRequestResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = JitRequestData.DeserializeJitRequestData(document.RootElement);
            return new JitRequestResource(_client, data);
        }

        async ValueTask<JitRequestResource> IOperationSource<JitRequestResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = JitRequestData.DeserializeJitRequestData(document.RootElement);
            return new JitRequestResource(_client, data);
        }
    }
}
