// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Resources
{
    internal class DeploymentStackOperationSource : IOperationSource<DeploymentStackResource>
    {
        private readonly ArmClient _client;

        internal DeploymentStackOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeploymentStackResource IOperationSource<DeploymentStackResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeploymentStackData.DeserializeDeploymentStackData(document.RootElement);
            return new DeploymentStackResource(_client, data);
        }

        async ValueTask<DeploymentStackResource> IOperationSource<DeploymentStackResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeploymentStackData.DeserializeDeploymentStackData(document.RootElement);
            return new DeploymentStackResource(_client, data);
        }
    }
}
