// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Resources
{
    internal class ArmApplicationOperationSource : IOperationSource<ArmApplicationResource>
    {
        private readonly ArmClient _client;

        internal ArmApplicationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ArmApplicationResource IOperationSource<ArmApplicationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ArmApplicationData.DeserializeArmApplicationData(document.RootElement);
            return new ArmApplicationResource(_client, data);
        }

        async ValueTask<ArmApplicationResource> IOperationSource<ArmApplicationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ArmApplicationData.DeserializeArmApplicationData(document.RootElement);
            return new ArmApplicationResource(_client, data);
        }
    }
}
