// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ManagementGroups;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A class representing a collection of <see cref="DeploymentStackResource"/> and their operations.
    /// Each <see cref="DeploymentStackResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>, <see cref="ResourceGroupResource"/> or <see cref="ManagementGroupResource"/>.
    /// To get a <see cref="DeploymentStackCollection"/> instance call the GetDeploymentStacks method from an instance of <see cref="SubscriptionResource"/>, <see cref="ResourceGroupResource"/> or <see cref="ManagementGroupResource"/>.
    /// </summary>
    public partial class DeploymentStackCollection : ArmCollection, IEnumerable<DeploymentStackResource>, IAsyncEnumerable<DeploymentStackResource>
    {
        private readonly ClientDiagnostics _deploymentStackClientDiagnostics;
        private readonly DeploymentStacksRestOperations _deploymentStackRestClient;

        /// <summary> Initializes a new instance of the <see cref="DeploymentStackCollection"/> class for mocking. </summary>
        protected DeploymentStackCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DeploymentStackCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DeploymentStackCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _deploymentStackClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Resources", DeploymentStackResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DeploymentStackResource.ResourceType, out string deploymentStackApiVersion);
            _deploymentStackRestClient = new DeploymentStacksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, deploymentStackApiVersion);
        }

        /// <summary>
        /// Creates or updates a Deployment stack at specific scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_CreateOrUpdateAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="data"> Deployment stack supplied to the operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DeploymentStackResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string deploymentStackName, DeploymentStackData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _deploymentStackRestClient.CreateOrUpdateAtScopeAsync(Id, deploymentStackName, data, cancellationToken).ConfigureAwait(false);
                var operation = new ResourcesArmOperation<DeploymentStackResource>(new DeploymentStackOperationSource(Client), _deploymentStackClientDiagnostics, Pipeline, _deploymentStackRestClient.CreateCreateOrUpdateAtScopeRequest(Id, deploymentStackName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a Deployment stack at specific scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_CreateOrUpdateAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="data"> Deployment stack supplied to the operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DeploymentStackResource> CreateOrUpdate(WaitUntil waitUntil, string deploymentStackName, DeploymentStackData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _deploymentStackRestClient.CreateOrUpdateAtScope(Id, deploymentStackName, data, cancellationToken);
                var operation = new ResourcesArmOperation<DeploymentStackResource>(new DeploymentStackOperationSource(Client), _deploymentStackClientDiagnostics, Pipeline, _deploymentStackRestClient.CreateCreateOrUpdateAtScopeRequest(Id, deploymentStackName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a Deployment stack with a given name at specific scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_GetAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> is null. </exception>
        public virtual async Task<Response<DeploymentStackResource>> GetAsync(string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.Get");
            scope.Start();
            try
            {
                var response = await _deploymentStackRestClient.GetAtScopeAsync(Id, deploymentStackName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DeploymentStackResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a Deployment stack with a given name at specific scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_GetAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> is null. </exception>
        public virtual Response<DeploymentStackResource> Get(string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.Get");
            scope.Start();
            try
            {
                var response = _deploymentStackRestClient.GetAtScope(Id, deploymentStackName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DeploymentStackResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the Deployment stacks within the specified scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_ListAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DeploymentStackResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DeploymentStackResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _deploymentStackRestClient.CreateListAtScopeRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _deploymentStackRestClient.CreateListAtScopeNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DeploymentStackResource(Client, DeploymentStackData.DeserializeDeploymentStackData(e)), _deploymentStackClientDiagnostics, Pipeline, "DeploymentStackCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the Deployment stacks within the specified scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_ListAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DeploymentStackResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DeploymentStackResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _deploymentStackRestClient.CreateListAtScopeRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _deploymentStackRestClient.CreateListAtScopeNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DeploymentStackResource(Client, DeploymentStackData.DeserializeDeploymentStackData(e)), _deploymentStackClientDiagnostics, Pipeline, "DeploymentStackCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_GetAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.Exists");
            scope.Start();
            try
            {
                var response = await _deploymentStackRestClient.GetAtScopeAsync(Id, deploymentStackName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_GetAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> is null. </exception>
        public virtual Response<bool> Exists(string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.Exists");
            scope.Start();
            try
            {
                var response = _deploymentStackRestClient.GetAtScope(Id, deploymentStackName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_GetAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> is null. </exception>
        public virtual async Task<NullableResponse<DeploymentStackResource>> GetIfExistsAsync(string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _deploymentStackRestClient.GetAtScopeAsync(Id, deploymentStackName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DeploymentStackResource>(response.GetRawResponse());
                return Response.FromValue(new DeploymentStackResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DeploymentStacks_GetAtScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeploymentStackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deploymentStackName"/> is null. </exception>
        public virtual NullableResponse<DeploymentStackResource> GetIfExists(string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var scope = _deploymentStackClientDiagnostics.CreateScope("DeploymentStackCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _deploymentStackRestClient.GetAtScope(Id, deploymentStackName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DeploymentStackResource>(response.GetRawResponse());
                return Response.FromValue(new DeploymentStackResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DeploymentStackResource> IEnumerable<DeploymentStackResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DeploymentStackResource> IAsyncEnumerable<DeploymentStackResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
