// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A Class representing a DataBoundary along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="DataBoundaryResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetDataBoundaryResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetDataBoundary method.
    /// </summary>
    public partial class DataBoundaryResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="DataBoundaryResource"/> instance. </summary>
        /// <param name="scope"> The scope. </param>
        /// <param name="name"> The name. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string scope, DataBoundaryName name)
        {
            var resourceId = $"{scope}/providers/Microsoft.Resources/dataBoundaries/{name}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _dataBoundaryClientDiagnostics;
        private readonly DataBoundariesRestOperations _dataBoundaryRestClient;
        private readonly DataBoundaryData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Resources/dataBoundaries";

        /// <summary> Initializes a new instance of the <see cref="DataBoundaryResource"/> class for mocking. </summary>
        protected DataBoundaryResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DataBoundaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal DataBoundaryResource(ArmClient client, DataBoundaryData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="DataBoundaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal DataBoundaryResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dataBoundaryClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Resources", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string dataBoundaryApiVersion);
            _dataBoundaryRestClient = new DataBoundariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dataBoundaryApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual DataBoundaryData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get data boundary at specified scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DataBoundaryResource>> GetAsync(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryResource.Get");
            scope.Start();
            try
            {
                var response = await _dataBoundaryRestClient.GetScopeAsync(Id.Parent, name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get data boundary at specified scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DataBoundaryResource> Get(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryResource.Get");
            scope.Start();
            try
            {
                var response = _dataBoundaryRestClient.GetScope(Id.Parent, name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
