// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A class representing a collection of <see cref="DataBoundaryResource"/> and their operations.
    /// Each <see cref="DataBoundaryResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="DataBoundaryCollection"/> instance call the GetDataBoundaries method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class DataBoundaryCollection : ArmCollection
    {
        private readonly ClientDiagnostics _dataBoundaryClientDiagnostics;
        private readonly DataBoundariesRestOperations _dataBoundaryRestClient;

        /// <summary> Initializes a new instance of the <see cref="DataBoundaryCollection"/> class for mocking. </summary>
        protected DataBoundaryCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DataBoundaryCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DataBoundaryCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dataBoundaryClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Resources", DataBoundaryResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DataBoundaryResource.ResourceType, out string dataBoundaryApiVersion);
            _dataBoundaryRestClient = new DataBoundariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dataBoundaryApiVersion);
        }

        /// <summary>
        /// Get data boundary at specified scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DataBoundaryResource>> GetAsync(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryCollection.Get");
            scope.Start();
            try
            {
                var response = await _dataBoundaryRestClient.GetScopeAsync(Id, name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get data boundary at specified scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DataBoundaryResource> Get(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryCollection.Get");
            scope.Start();
            try
            {
                var response = _dataBoundaryRestClient.GetScope(Id, name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryCollection.Exists");
            scope.Start();
            try
            {
                var response = await _dataBoundaryRestClient.GetScopeAsync(Id, name, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryCollection.Exists");
            scope.Start();
            try
            {
                var response = _dataBoundaryRestClient.GetScope(Id, name, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<DataBoundaryResource>> GetIfExistsAsync(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _dataBoundaryRestClient.GetScopeAsync(Id, name, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DataBoundaryResource>(response.GetRawResponse());
                return Response.FromValue(new DataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetScope</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<DataBoundaryResource> GetIfExists(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _dataBoundaryClientDiagnostics.CreateScope("DataBoundaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _dataBoundaryRestClient.GetScope(Id, name, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DataBoundaryResource>(response.GetRawResponse());
                return Response.FromValue(new DataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
