// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmResourcesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Resources.TemplateSpecData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported Azure locations. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="description"> Template Spec description. </param>
        /// <param name="displayName"> Template Spec display name. </param>
        /// <param name="metadata"> The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs. </param>
        /// <param name="versions"> High-level information about the versions within this Template Spec. The keys are the version names. Only populated if the $expand query parameter is set to 'versions'. </param>
        /// <returns> A new <see cref="Resources.TemplateSpecData"/> instance for mocking. </returns>
        public static TemplateSpecData TemplateSpecData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation location = default, IDictionary<string, string> tags = null, string description = null, string displayName = null, BinaryData metadata = null, IReadOnlyDictionary<string, TemplateSpecVersionInfo> versions = null)
        {
            tags ??= new Dictionary<string, string>();
            versions ??= new Dictionary<string, TemplateSpecVersionInfo>();

            return new TemplateSpecData(
                id,
                name,
                resourceType,
                systemData,
                location,
                tags,
                description,
                displayName,
                metadata,
                versions,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemplateSpecVersionInfo"/>. </summary>
        /// <param name="description"> Template Spec version description. </param>
        /// <param name="timeCreated"> The timestamp of when the version was created. </param>
        /// <param name="timeModified"> The timestamp of when the version was last modified. </param>
        /// <returns> A new <see cref="Models.TemplateSpecVersionInfo"/> instance for mocking. </returns>
        public static TemplateSpecVersionInfo TemplateSpecVersionInfo(string description = null, DateTimeOffset? timeCreated = null, DateTimeOffset? timeModified = null)
        {
            return new TemplateSpecVersionInfo(description, timeCreated, timeModified, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemplateSpecPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.TemplateSpecPatch"/> instance for mocking. </returns>
        public static TemplateSpecPatch TemplateSpecPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new TemplateSpecPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.TemplateSpecVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the Template Spec Version. It must match the location of the parent Template Spec. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="description"> Template Spec version description. </param>
        /// <param name="linkedTemplates"> An array of linked template artifacts. </param>
        /// <param name="metadata"> The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs. </param>
        /// <param name="mainTemplate"> The main Azure Resource Manager template content. </param>
        /// <param name="uiFormDefinition"> The Azure Resource Manager template UI definition content. </param>
        /// <returns> A new <see cref="Resources.TemplateSpecVersionData"/> instance for mocking. </returns>
        public static TemplateSpecVersionData TemplateSpecVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation location = default, IDictionary<string, string> tags = null, string description = null, IEnumerable<LinkedTemplateArtifact> linkedTemplates = null, BinaryData metadata = null, BinaryData mainTemplate = null, BinaryData uiFormDefinition = null)
        {
            tags ??= new Dictionary<string, string>();
            linkedTemplates ??= new List<LinkedTemplateArtifact>();

            return new TemplateSpecVersionData(
                id,
                name,
                resourceType,
                systemData,
                location,
                tags,
                description,
                linkedTemplates?.ToList(),
                metadata,
                mainTemplate,
                uiFormDefinition,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemplateSpecVersionPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.TemplateSpecVersionPatch"/> instance for mocking. </returns>
        public static TemplateSpecVersionPatch TemplateSpecVersionPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new TemplateSpecVersionPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.ArmDeploymentScriptData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="identity"> Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported. </param>
        /// <param name="location"> The location of the ACI and the storage account for the deployment script. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="kind"> Type of the script. </param>
        /// <returns> A new <see cref="Resources.ArmDeploymentScriptData"/> instance for mocking. </returns>
        public static ArmDeploymentScriptData ArmDeploymentScriptData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ArmDeploymentScriptManagedIdentity identity = null, AzureLocation location = default, IDictionary<string, string> tags = null, string kind = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ArmDeploymentScriptData(
                id,
                name,
                resourceType,
                systemData,
                identity,
                location,
                tags,
                kind == null ? default : new ScriptType(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentScriptManagedIdentity"/>. </summary>
        /// <param name="identityType"> Type of the managed identity. </param>
        /// <param name="tenantId"> ID of the Azure Active Directory. </param>
        /// <param name="userAssignedIdentities"> The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentScriptManagedIdentity"/> instance for mocking. </returns>
        public static ArmDeploymentScriptManagedIdentity ArmDeploymentScriptManagedIdentity(ArmDeploymentScriptManagedIdentityType? identityType = null, Guid? tenantId = null, IDictionary<string, UserAssignedIdentity> userAssignedIdentities = null)
        {
            userAssignedIdentities ??= new Dictionary<string, UserAssignedIdentity>();

            return new ArmDeploymentScriptManagedIdentity(identityType, tenantId, userAssignedIdentities, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentScriptPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> Resource tags to be updated. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentScriptPatch"/> instance for mocking. </returns>
        public static ArmDeploymentScriptPatch ArmDeploymentScriptPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ArmDeploymentScriptPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.ScriptLogData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="log"> Script execution logs in text format. </param>
        /// <returns> A new <see cref="Resources.ScriptLogData"/> instance for mocking. </returns>
        public static ScriptLogData ScriptLogData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string log = null)
        {
            return new ScriptLogData(
                id,
                name,
                resourceType,
                systemData,
                log,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentContent"/>. </summary>
        /// <param name="location"> The location to store the deployment data. </param>
        /// <param name="properties"> The deployment properties. </param>
        /// <param name="tags"> Deployment tags. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentContent"/> instance for mocking. </returns>
        public static ArmDeploymentContent ArmDeploymentContent(AzureLocation? location = null, ArmDeploymentProperties properties = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ArmDeploymentContent(location, properties, tags, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentProperties"/>. </summary>
        /// <param name="template"> The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both. </param>
        /// <param name="templateLink"> The URI of the template. Use either the templateLink property or the template property, but not both. </param>
        /// <param name="parameters"> Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string. </param>
        /// <param name="parametersLink"> The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both. </param>
        /// <param name="mode"> The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources. </param>
        /// <param name="debugSettingDetailLevel"> The debug setting of the deployment. </param>
        /// <param name="errorDeployment"> The deployment on error behavior. </param>
        /// <param name="expressionEvaluationScope"> Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentProperties"/> instance for mocking. </returns>
        public static ArmDeploymentProperties ArmDeploymentProperties(BinaryData template = null, ArmDeploymentTemplateLink templateLink = null, BinaryData parameters = null, ArmDeploymentParametersLink parametersLink = null, ArmDeploymentMode mode = default, string debugSettingDetailLevel = null, ErrorDeployment errorDeployment = null, ExpressionEvaluationScope? expressionEvaluationScope = null)
        {
            return new ArmDeploymentProperties(
                template,
                templateLink,
                parameters,
                parametersLink,
                mode,
                debugSettingDetailLevel != null ? new DebugSetting(debugSettingDetailLevel, serializedAdditionalRawData: null) : null,
                errorDeployment,
                expressionEvaluationScope != null ? new ExpressionEvaluationOptions(expressionEvaluationScope, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.ArmDeploymentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> the location of the deployment. </param>
        /// <param name="properties"> Deployment properties. </param>
        /// <param name="tags"> Deployment tags. </param>
        /// <returns> A new <see cref="Resources.ArmDeploymentData"/> instance for mocking. </returns>
        public static ArmDeploymentData ArmDeploymentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ArmDeploymentPropertiesExtended properties = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ArmDeploymentData(
                id,
                name,
                resourceType,
                systemData,
                location,
                properties,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentPropertiesExtended"/>. </summary>
        /// <param name="provisioningState"> Denotes the state of provisioning. </param>
        /// <param name="correlationId"> The correlation ID of the deployment. </param>
        /// <param name="timestamp"> The timestamp of the template deployment. </param>
        /// <param name="duration"> The duration of the template deployment. </param>
        /// <param name="outputs"> Key/value pairs that represent deployment output. </param>
        /// <param name="providers"> The list of resource providers needed for the deployment. </param>
        /// <param name="dependencies"> The list of deployment dependencies. </param>
        /// <param name="templateLink"> The URI referencing the template. </param>
        /// <param name="parameters"> Deployment parameters. </param>
        /// <param name="parametersLink"> The URI referencing the parameters. </param>
        /// <param name="mode"> The deployment mode. Possible values are Incremental and Complete. </param>
        /// <param name="debugSettingDetailLevel"> The debug setting of the deployment. </param>
        /// <param name="errorDeployment"> The deployment on error behavior. </param>
        /// <param name="templateHash"> The hash produced for the template. </param>
        /// <param name="outputResources"> Array of provisioned resources. </param>
        /// <param name="validatedResources"> Array of validated resources. </param>
        /// <param name="error"> The deployment error. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentPropertiesExtended"/> instance for mocking. </returns>
        public static ArmDeploymentPropertiesExtended ArmDeploymentPropertiesExtended(ResourcesProvisioningState? provisioningState = null, string correlationId = null, DateTimeOffset? timestamp = null, TimeSpan? duration = null, BinaryData outputs = null, IEnumerable<ResourceProviderData> providers = null, IEnumerable<ArmDependency> dependencies = null, ArmDeploymentTemplateLink templateLink = null, BinaryData parameters = null, ArmDeploymentParametersLink parametersLink = null, ArmDeploymentMode? mode = null, string debugSettingDetailLevel = null, ErrorDeploymentExtended errorDeployment = null, string templateHash = null, IEnumerable<SubResource> outputResources = null, IEnumerable<SubResource> validatedResources = null, ResponseError error = null)
        {
            providers ??= new List<ResourceProviderData>();
            dependencies ??= new List<ArmDependency>();
            outputResources ??= new List<SubResource>();
            validatedResources ??= new List<SubResource>();

            return new ArmDeploymentPropertiesExtended(
                provisioningState,
                correlationId,
                timestamp,
                duration,
                outputs,
                providers?.ToList(),
                dependencies?.ToList(),
                templateLink,
                parameters,
                parametersLink,
                mode,
                debugSettingDetailLevel != null ? new DebugSetting(debugSettingDetailLevel, serializedAdditionalRawData: null) : null,
                errorDeployment,
                templateHash,
                outputResources?.ToList(),
                validatedResources?.ToList(),
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDependency"/>. </summary>
        /// <param name="dependsOn"> The list of dependencies. </param>
        /// <param name="id"> The ID of the dependency. </param>
        /// <param name="resourceType"> The dependency resource type. </param>
        /// <param name="resourceName"> The dependency resource name. </param>
        /// <returns> A new <see cref="Models.ArmDependency"/> instance for mocking. </returns>
        public static ArmDependency ArmDependency(IEnumerable<BasicArmDependency> dependsOn = null, string id = null, ResourceType? resourceType = null, string resourceName = null)
        {
            dependsOn ??= new List<BasicArmDependency>();

            return new ArmDependency(dependsOn?.ToList(), id, resourceType, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BasicArmDependency"/>. </summary>
        /// <param name="id"> The ID of the dependency. </param>
        /// <param name="resourceType"> The dependency resource type. </param>
        /// <param name="resourceName"> The dependency resource name. </param>
        /// <returns> A new <see cref="Models.BasicArmDependency"/> instance for mocking. </returns>
        public static BasicArmDependency BasicArmDependency(string id = null, ResourceType? resourceType = null, string resourceName = null)
        {
            return new BasicArmDependency(id, resourceType, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ErrorDeploymentExtended"/>. </summary>
        /// <param name="provisioningState"> The state of the provisioning for the on error deployment. </param>
        /// <param name="deploymentType"> The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment. </param>
        /// <param name="deploymentName"> The deployment to be used on error case. </param>
        /// <returns> A new <see cref="Models.ErrorDeploymentExtended"/> instance for mocking. </returns>
        public static ErrorDeploymentExtended ErrorDeploymentExtended(string provisioningState = null, ErrorDeploymentType? deploymentType = null, string deploymentName = null)
        {
            return new ErrorDeploymentExtended(provisioningState, deploymentType, deploymentName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentValidateResult"/>. </summary>
        /// <param name="error"> The deployment validation error. </param>
        /// <param name="properties"> The template deployment properties. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentValidateResult"/> instance for mocking. </returns>
        public static ArmDeploymentValidateResult ArmDeploymentValidateResult(ResponseError error = null, ArmDeploymentPropertiesExtended properties = null)
        {
            return new ArmDeploymentValidateResult(error, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentExportResult"/>. </summary>
        /// <param name="template"> The template content. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentExportResult"/> instance for mocking. </returns>
        public static ArmDeploymentExportResult ArmDeploymentExportResult(BinaryData template = null)
        {
            return new ArmDeploymentExportResult(template, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentWhatIfContent"/>. </summary>
        /// <param name="location"> The location to store the deployment data, only required at the tenant and management group scope. </param>
        /// <param name="properties"> The deployment properties. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentWhatIfContent"/> instance for mocking. </returns>
        public static ArmDeploymentWhatIfContent ArmDeploymentWhatIfContent(AzureLocation? location = null, ArmDeploymentWhatIfProperties properties = null)
        {
            return new ArmDeploymentWhatIfContent(location, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentWhatIfProperties"/>. </summary>
        /// <param name="template"> The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both. </param>
        /// <param name="templateLink"> The URI of the template. Use either the templateLink property or the template property, but not both. </param>
        /// <param name="parameters"> Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string. </param>
        /// <param name="parametersLink"> The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both. </param>
        /// <param name="mode"> The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources. </param>
        /// <param name="debugSettingDetailLevel"> The debug setting of the deployment. </param>
        /// <param name="errorDeployment"> The deployment on error behavior. </param>
        /// <param name="expressionEvaluationScope"> Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer. </param>
        /// <param name="whatIfResultFormat"> Optional What-If operation settings. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentWhatIfProperties"/> instance for mocking. </returns>
        public static ArmDeploymentWhatIfProperties ArmDeploymentWhatIfProperties(BinaryData template = null, ArmDeploymentTemplateLink templateLink = null, BinaryData parameters = null, ArmDeploymentParametersLink parametersLink = null, ArmDeploymentMode mode = default, string debugSettingDetailLevel = null, ErrorDeployment errorDeployment = null, ExpressionEvaluationScope? expressionEvaluationScope = null, WhatIfResultFormat? whatIfResultFormat = null)
        {
            return new ArmDeploymentWhatIfProperties(
                template,
                templateLink,
                parameters,
                parametersLink,
                mode,
                debugSettingDetailLevel != null ? new DebugSetting(debugSettingDetailLevel, serializedAdditionalRawData: null) : null,
                errorDeployment,
                expressionEvaluationScope != null ? new ExpressionEvaluationOptions(expressionEvaluationScope, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null,
                whatIfResultFormat != null ? new ArmDeploymentWhatIfSettings(whatIfResultFormat, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WhatIfOperationResult"/>. </summary>
        /// <param name="status"> Status of the What-If operation. </param>
        /// <param name="error"> Error when What-If operation fails. </param>
        /// <param name="changes"> List of resource changes predicted by What-If operation. </param>
        /// <returns> A new <see cref="Models.WhatIfOperationResult"/> instance for mocking. </returns>
        public static WhatIfOperationResult WhatIfOperationResult(string status = null, ResponseError error = null, IEnumerable<WhatIfChange> changes = null)
        {
            changes ??= new List<WhatIfChange>();

            return new WhatIfOperationResult(status, error, changes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WhatIfChange"/>. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="changeType"> Type of change that will be made to the resource when the deployment is executed. </param>
        /// <param name="unsupportedReason"> The explanation about why the resource is unsupported by What-If. </param>
        /// <param name="before"> The snapshot of the resource before the deployment is executed. </param>
        /// <param name="after"> The predicted snapshot of the resource after the deployment is executed. </param>
        /// <param name="delta"> The predicted changes to resource properties. </param>
        /// <returns> A new <see cref="Models.WhatIfChange"/> instance for mocking. </returns>
        public static WhatIfChange WhatIfChange(string resourceId = null, WhatIfChangeType changeType = default, string unsupportedReason = null, BinaryData before = null, BinaryData after = null, IEnumerable<WhatIfPropertyChange> delta = null)
        {
            delta ??= new List<WhatIfPropertyChange>();

            return new WhatIfChange(
                resourceId,
                changeType,
                unsupportedReason,
                before,
                after,
                delta?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WhatIfPropertyChange"/>. </summary>
        /// <param name="path"> The path of the property. </param>
        /// <param name="propertyChangeType"> The type of property change. </param>
        /// <param name="before"> The value of the property before the deployment is executed. </param>
        /// <param name="after"> The value of the property after the deployment is executed. </param>
        /// <param name="children"> Nested property changes. </param>
        /// <returns> A new <see cref="Models.WhatIfPropertyChange"/> instance for mocking. </returns>
        public static WhatIfPropertyChange WhatIfPropertyChange(string path = null, WhatIfPropertyChangeType propertyChangeType = default, BinaryData before = null, BinaryData after = null, IEnumerable<WhatIfPropertyChange> children = null)
        {
            children ??= new List<WhatIfPropertyChange>();

            return new WhatIfPropertyChange(
                path,
                propertyChangeType,
                before,
                after,
                children?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentOperation"/>. </summary>
        /// <param name="id"> Full deployment operation ID. </param>
        /// <param name="operationId"> Deployment operation ID. </param>
        /// <param name="properties"> Deployment properties. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentOperation"/> instance for mocking. </returns>
        public static ArmDeploymentOperation ArmDeploymentOperation(string id = null, string operationId = null, ArmDeploymentOperationProperties properties = null)
        {
            return new ArmDeploymentOperation(id, operationId, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmDeploymentOperationProperties"/>. </summary>
        /// <param name="provisioningOperation"> The name of the current provisioning operation. </param>
        /// <param name="provisioningState"> The state of the provisioning. </param>
        /// <param name="timestamp"> The date and time of the operation. </param>
        /// <param name="duration"> The duration of the operation. </param>
        /// <param name="serviceRequestId"> Deployment operation service request id. </param>
        /// <param name="statusCode"> Operation status code from the resource provider. This property may not be set if a response has not yet been received. </param>
        /// <param name="statusMessage"> Operation status message from the resource provider. This property is optional.  It will only be provided if an error was received from the resource provider. </param>
        /// <param name="targetResource"> The target resource. </param>
        /// <param name="requestContent"> The HTTP request message. </param>
        /// <param name="responseContent"> The HTTP response message. </param>
        /// <returns> A new <see cref="Models.ArmDeploymentOperationProperties"/> instance for mocking. </returns>
        public static ArmDeploymentOperationProperties ArmDeploymentOperationProperties(ProvisioningOperationKind? provisioningOperation = null, string provisioningState = null, DateTimeOffset? timestamp = null, TimeSpan? duration = null, string serviceRequestId = null, string statusCode = null, StatusMessage statusMessage = null, TargetResource targetResource = null, BinaryData requestContent = null, BinaryData responseContent = null)
        {
            return new ArmDeploymentOperationProperties(
                provisioningOperation,
                provisioningState,
                timestamp,
                duration,
                serviceRequestId,
                statusCode,
                statusMessage,
                targetResource,
                requestContent != null ? new HttpMessage(requestContent, serializedAdditionalRawData: null) : null,
                responseContent != null ? new HttpMessage(responseContent, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StatusMessage"/>. </summary>
        /// <param name="status"> Status of the deployment operation. </param>
        /// <param name="error"> The error reported by the operation. </param>
        /// <returns> A new <see cref="Models.StatusMessage"/> instance for mocking. </returns>
        public static StatusMessage StatusMessage(string status = null, ResponseError error = null)
        {
            return new StatusMessage(status, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TargetResource"/>. </summary>
        /// <param name="id"> The ID of the resource. </param>
        /// <param name="resourceName"> The name of the resource. </param>
        /// <param name="resourceType"> The type of the resource. </param>
        /// <returns> A new <see cref="Models.TargetResource"/> instance for mocking. </returns>
        public static TargetResource TargetResource(string id = null, string resourceName = null, ResourceType? resourceType = null)
        {
            return new TargetResource(id, resourceName, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemplateHashResult"/>. </summary>
        /// <param name="minifiedTemplate"> The minified template string. </param>
        /// <param name="templateHash"> The template hash. </param>
        /// <returns> A new <see cref="Models.TemplateHashResult"/> instance for mocking. </returns>
        public static TemplateHashResult TemplateHashResult(string minifiedTemplate = null, string templateHash = null)
        {
            return new TemplateHashResult(minifiedTemplate, templateHash, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.ArmApplicationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="managedBy"> ID of the resource that manages this resource. </param>
        /// <param name="sku"> The SKU of the resource. </param>
        /// <param name="plan"> The plan information. </param>
        /// <param name="kind"> The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="managedResourceGroupId"> The managed resource group Id. </param>
        /// <param name="applicationDefinitionId"> The fully qualified path of managed application definition Id. </param>
        /// <param name="parameters"> Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string. </param>
        /// <param name="outputs"> Name and value pairs that define the managed application outputs. </param>
        /// <param name="provisioningState"> The managed application provisioning state. </param>
        /// <param name="billingDetailsResourceUsageId"> The managed application billing details. </param>
        /// <param name="jitAccessPolicy"> The managed application Jit access policy. </param>
        /// <param name="publisherTenantId"> The publisher tenant Id. </param>
        /// <param name="authorizations"> The  read-only authorizations property that is retrieved from the application package. </param>
        /// <param name="managementMode"> The managed application management mode. </param>
        /// <param name="customerSupport"> The read-only customer support property that is retrieved from the application package. </param>
        /// <param name="supportUris"> The read-only support URLs property that is retrieved from the application package. </param>
        /// <param name="artifacts"> The collection of managed application artifacts. </param>
        /// <param name="createdBy"> The client entity that created the JIT request. </param>
        /// <param name="updatedBy"> The client entity that last updated the JIT request. </param>
        /// <returns> A new <see cref="Resources.ArmApplicationData"/> instance for mocking. </returns>
        public static ArmApplicationData ArmApplicationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string managedBy = null, ArmApplicationSku sku = null, ArmPlan plan = null, string kind = null, ArmApplicationManagedIdentity identity = null, ResourceIdentifier managedResourceGroupId = null, ResourceIdentifier applicationDefinitionId = null, BinaryData parameters = null, BinaryData outputs = null, ResourcesProvisioningState? provisioningState = null, string billingDetailsResourceUsageId = null, ArmApplicationJitAccessPolicy jitAccessPolicy = null, Guid? publisherTenantId = null, IEnumerable<ArmApplicationAuthorization> authorizations = null, ArmApplicationManagementMode? managementMode = null, ArmApplicationPackageContact customerSupport = null, ArmApplicationPackageSupportUris supportUris = null, IEnumerable<ArmApplicationArtifact> artifacts = null, ArmApplicationDetails createdBy = null, ArmApplicationDetails updatedBy = null)
        {
            tags ??= new Dictionary<string, string>();
            authorizations ??= new List<ArmApplicationAuthorization>();
            artifacts ??= new List<ArmApplicationArtifact>();

            return new ArmApplicationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                managedBy,
                sku,
                serializedAdditionalRawData: null,
                plan,
                kind,
                identity,
                managedResourceGroupId,
                applicationDefinitionId,
                parameters,
                outputs,
                provisioningState,
                billingDetailsResourceUsageId != null ? new ArmApplicationBillingDetails(billingDetailsResourceUsageId, serializedAdditionalRawData: null) : null,
                jitAccessPolicy,
                publisherTenantId,
                authorizations?.ToList(),
                managementMode,
                customerSupport,
                supportUris,
                artifacts?.ToList(),
                createdBy,
                updatedBy);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationPackageContact"/>. </summary>
        /// <param name="contactName"> The contact name. </param>
        /// <param name="email"> The contact email. </param>
        /// <param name="phone"> The contact phone number. </param>
        /// <returns> A new <see cref="Models.ArmApplicationPackageContact"/> instance for mocking. </returns>
        public static ArmApplicationPackageContact ArmApplicationPackageContact(string contactName = null, string email = null, string phone = null)
        {
            return new ArmApplicationPackageContact(contactName, email, phone, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationPackageSupportUris"/>. </summary>
        /// <param name="azurePublicCloudUri"> The public azure support URL. </param>
        /// <param name="azureGovernmentUri"> The government cloud support URL. </param>
        /// <returns> A new <see cref="Models.ArmApplicationPackageSupportUris"/> instance for mocking. </returns>
        public static ArmApplicationPackageSupportUris ArmApplicationPackageSupportUris(Uri azurePublicCloudUri = null, Uri azureGovernmentUri = null)
        {
            return new ArmApplicationPackageSupportUris(azurePublicCloudUri, azureGovernmentUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationArtifact"/>. </summary>
        /// <param name="name"> The managed application artifact name. </param>
        /// <param name="uri"> The managed application artifact blob uri. </param>
        /// <param name="artifactType"> The managed application artifact type. </param>
        /// <returns> A new <see cref="Models.ArmApplicationArtifact"/> instance for mocking. </returns>
        public static ArmApplicationArtifact ArmApplicationArtifact(ArmApplicationArtifactName name = default, Uri uri = null, ArmApplicationArtifactType artifactType = default)
        {
            return new ArmApplicationArtifact(name, uri, artifactType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationDetails"/>. </summary>
        /// <param name="objectId"> The client Oid. </param>
        /// <param name="puid"> The client Puid. </param>
        /// <param name="applicationId"> The client application Id. </param>
        /// <returns> A new <see cref="Models.ArmApplicationDetails"/> instance for mocking. </returns>
        public static ArmApplicationDetails ArmApplicationDetails(Guid? objectId = null, string puid = null, Guid? applicationId = null)
        {
            return new ArmApplicationDetails(objectId, puid, applicationId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationManagedIdentity"/>. </summary>
        /// <param name="principalId"> The principal ID of resource identity. </param>
        /// <param name="tenantId"> The tenant ID of resource. </param>
        /// <param name="identityType"> The identity type. </param>
        /// <param name="userAssignedIdentities"> The list of user identities associated with the resource. The user identity dictionary key references will be resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'. </param>
        /// <returns> A new <see cref="Models.ArmApplicationManagedIdentity"/> instance for mocking. </returns>
        public static ArmApplicationManagedIdentity ArmApplicationManagedIdentity(Guid? principalId = null, Guid? tenantId = null, ArmApplicationManagedIdentityType? identityType = null, IDictionary<string, ArmApplicationUserAssignedIdentity> userAssignedIdentities = null)
        {
            userAssignedIdentities ??= new Dictionary<string, ArmApplicationUserAssignedIdentity>();

            return new ArmApplicationManagedIdentity(principalId, tenantId, identityType, userAssignedIdentities, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationUserAssignedIdentity"/>. </summary>
        /// <param name="principalId"> The principal id of user assigned identity. </param>
        /// <param name="tenantId"> The tenant id of user assigned identity. </param>
        /// <returns> A new <see cref="Models.ArmApplicationUserAssignedIdentity"/> instance for mocking. </returns>
        public static ArmApplicationUserAssignedIdentity ArmApplicationUserAssignedIdentity(Guid? principalId = null, Guid? tenantId = null)
        {
            return new ArmApplicationUserAssignedIdentity(principalId, tenantId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="managedBy"> ID of the resource that manages this resource. </param>
        /// <param name="sku"> The SKU of the resource. </param>
        /// <returns> A new <see cref="Models.ArmApplicationResourceData"/> instance for mocking. </returns>
        public static ArmApplicationResourceData ArmApplicationResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string managedBy = null, ArmApplicationSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ArmApplicationResourceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                managedBy,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ArmApplicationPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="managedBy"> ID of the resource that manages this resource. </param>
        /// <param name="sku"> The SKU of the resource. </param>
        /// <param name="plan"> The plan information. </param>
        /// <param name="kind"> The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="managedResourceGroupId"> The managed resource group Id. </param>
        /// <param name="applicationDefinitionId"> The fully qualified path of managed application definition Id. </param>
        /// <param name="parameters"> Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string. </param>
        /// <param name="outputs"> Name and value pairs that define the managed application outputs. </param>
        /// <param name="provisioningState"> The managed application provisioning state. </param>
        /// <param name="billingDetailsResourceUsageId"> The managed application billing details. </param>
        /// <param name="jitAccessPolicy"> The managed application Jit access policy. </param>
        /// <param name="publisherTenantId"> The publisher tenant Id. </param>
        /// <param name="authorizations"> The  read-only authorizations property that is retrieved from the application package. </param>
        /// <param name="managementMode"> The managed application management mode. </param>
        /// <param name="customerSupport"> The read-only customer support property that is retrieved from the application package. </param>
        /// <param name="supportUris"> The read-only support URLs property that is retrieved from the application package. </param>
        /// <param name="artifacts"> The collection of managed application artifacts. </param>
        /// <param name="createdBy"> The client entity that created the JIT request. </param>
        /// <param name="updatedBy"> The client entity that last updated the JIT request. </param>
        /// <returns> A new <see cref="Models.ArmApplicationPatch"/> instance for mocking. </returns>
        public static ArmApplicationPatch ArmApplicationPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string managedBy = null, ArmApplicationSku sku = null, ArmPlan plan = null, string kind = null, ArmApplicationManagedIdentity identity = null, ResourceIdentifier managedResourceGroupId = null, ResourceIdentifier applicationDefinitionId = null, BinaryData parameters = null, BinaryData outputs = null, ResourcesProvisioningState? provisioningState = null, string billingDetailsResourceUsageId = null, ArmApplicationJitAccessPolicy jitAccessPolicy = null, Guid? publisherTenantId = null, IEnumerable<ArmApplicationAuthorization> authorizations = null, ArmApplicationManagementMode? managementMode = null, ArmApplicationPackageContact customerSupport = null, ArmApplicationPackageSupportUris supportUris = null, IEnumerable<ArmApplicationArtifact> artifacts = null, ArmApplicationDetails createdBy = null, ArmApplicationDetails updatedBy = null)
        {
            tags ??= new Dictionary<string, string>();
            authorizations ??= new List<ArmApplicationAuthorization>();
            artifacts ??= new List<ArmApplicationArtifact>();

            return new ArmApplicationPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                managedBy,
                sku,
                serializedAdditionalRawData: null,
                plan,
                kind,
                identity,
                managedResourceGroupId,
                applicationDefinitionId,
                parameters,
                outputs,
                provisioningState,
                billingDetailsResourceUsageId != null ? new ArmApplicationBillingDetails(billingDetailsResourceUsageId, serializedAdditionalRawData: null) : null,
                jitAccessPolicy,
                publisherTenantId,
                authorizations?.ToList(),
                managementMode,
                customerSupport,
                supportUris,
                artifacts?.ToList(),
                createdBy,
                updatedBy);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.ArmApplicationDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="managedBy"> ID of the resource that manages this resource. </param>
        /// <param name="sku"> The SKU of the resource. </param>
        /// <param name="lockLevel"> The managed application lock level. </param>
        /// <param name="displayName"> The managed application definition display name. </param>
        /// <param name="isEnabled"> A value indicating whether the package is enabled or not. </param>
        /// <param name="authorizations"> The managed application provider authorizations. </param>
        /// <param name="artifacts"> The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition. </param>
        /// <param name="description"> The managed application definition description. </param>
        /// <param name="packageFileUri"> The managed application definition package file Uri. Use this element. </param>
        /// <param name="mainTemplate"> The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string. </param>
        /// <param name="createUiDefinition"> The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string. </param>
        /// <param name="notificationEndpoints"> The managed application notification policy. </param>
        /// <param name="lockingPolicy"> The managed application locking policy. </param>
        /// <param name="deploymentMode"> The managed application deployment policy. </param>
        /// <param name="managementMode"> The managed application management policy that determines publisher's access to the managed resource group. </param>
        /// <param name="policies"> The managed application provider policies. </param>
        /// <returns> A new <see cref="Resources.ArmApplicationDefinitionData"/> instance for mocking. </returns>
        public static ArmApplicationDefinitionData ArmApplicationDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string managedBy = null, ArmApplicationSku sku = null, ArmApplicationLockLevel lockLevel = default, string displayName = null, bool? isEnabled = null, IEnumerable<ArmApplicationAuthorization> authorizations = null, IEnumerable<ArmApplicationDefinitionArtifact> artifacts = null, string description = null, Uri packageFileUri = null, BinaryData mainTemplate = null, BinaryData createUiDefinition = null, IEnumerable<ArmApplicationNotificationEndpoint> notificationEndpoints = null, ArmApplicationPackageLockingPolicy lockingPolicy = null, ArmApplicationDeploymentMode? deploymentMode = null, ArmApplicationManagementMode? managementMode = null, IEnumerable<ArmApplicationPolicy> policies = null)
        {
            tags ??= new Dictionary<string, string>();
            authorizations ??= new List<ArmApplicationAuthorization>();
            artifacts ??= new List<ArmApplicationDefinitionArtifact>();
            notificationEndpoints ??= new List<ArmApplicationNotificationEndpoint>();
            policies ??= new List<ArmApplicationPolicy>();

            return new ArmApplicationDefinitionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                managedBy,
                sku,
                serializedAdditionalRawData: null,
                lockLevel,
                displayName,
                isEnabled,
                authorizations?.ToList(),
                artifacts?.ToList(),
                description,
                packageFileUri,
                mainTemplate,
                createUiDefinition,
                notificationEndpoints != null ? new ArmApplicationNotificationPolicy(notificationEndpoints?.ToList(), serializedAdditionalRawData: null) : null,
                lockingPolicy,
                deploymentMode.HasValue ? new ArmApplicationDeploymentPolicy(deploymentMode.Value, serializedAdditionalRawData: null) : null,
                managementMode != null ? new ArmApplicationManagementPolicy(managementMode, serializedAdditionalRawData: null) : null,
                policies?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Resources.JitRequestData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="applicationResourceId"> The parent application id. </param>
        /// <param name="publisherTenantId"> The publisher tenant id. </param>
        /// <param name="jitAuthorizationPolicies"> The JIT authorization policies. </param>
        /// <param name="jitSchedulingPolicy"> The JIT request properties. </param>
        /// <param name="provisioningState"> The JIT request provisioning state. </param>
        /// <param name="jitRequestState"> The JIT request state. </param>
        /// <param name="createdBy"> The client entity that created the JIT request. </param>
        /// <param name="updatedBy"> The client entity that last updated the JIT request. </param>
        /// <returns> A new <see cref="Resources.JitRequestData"/> instance for mocking. </returns>
        public static JitRequestData JitRequestData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string applicationResourceId = null, Guid? publisherTenantId = null, IEnumerable<JitAuthorizationPolicies> jitAuthorizationPolicies = null, JitSchedulingPolicy jitSchedulingPolicy = null, ResourcesProvisioningState? provisioningState = null, JitRequestState? jitRequestState = null, ArmApplicationDetails createdBy = null, ArmApplicationDetails updatedBy = null)
        {
            tags ??= new Dictionary<string, string>();
            jitAuthorizationPolicies ??= new List<JitAuthorizationPolicies>();

            return new JitRequestData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                applicationResourceId,
                publisherTenantId,
                jitAuthorizationPolicies?.ToList(),
                jitSchedulingPolicy,
                provisioningState,
                jitRequestState,
                createdBy,
                updatedBy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DecompileOperationSuccessResult"/>. </summary>
        /// <param name="files"> An array of key-value pairs containing the entryPoint string as the key for the Bicep file decompiled from the ARM json template. </param>
        /// <param name="entryPoint"> The file path to the main Bicep file generated from the decompiled ARM json template. </param>
        /// <returns> A new <see cref="Models.DecompileOperationSuccessResult"/> instance for mocking. </returns>
        public static DecompileOperationSuccessResult DecompileOperationSuccessResult(IEnumerable<DecompiledFileDefinition> files = null, string entryPoint = null)
        {
            files ??= new List<DecompiledFileDefinition>();

            return new DecompileOperationSuccessResult(files?.ToList(), entryPoint, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DecompiledFileDefinition"/>. </summary>
        /// <param name="path"></param>
        /// <param name="contents"></param>
        /// <returns> A new <see cref="Models.DecompiledFileDefinition"/> instance for mocking. </returns>
        public static DecompiledFileDefinition DecompiledFileDefinition(string path = null, string contents = null)
        {
            return new DecompiledFileDefinition(path, contents, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DeploymentStackTemplateDefinition"/>. </summary>
        /// <param name="template"> The template content. Use this element to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both. </param>
        /// <param name="templateLink"> The URI of the template. Use either the templateLink property or the template property, but not both. </param>
        /// <returns> A new <see cref="Models.DeploymentStackTemplateDefinition"/> instance for mocking. </returns>
        public static DeploymentStackTemplateDefinition DeploymentStackTemplateDefinition(BinaryData template = null, DeploymentStacksTemplateLink templateLink = null)
        {
            return new DeploymentStackTemplateDefinition(template, templateLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.DeploymentStackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the Deployment stack. It cannot be changed after creation. It must be one of the supported Azure locations. </param>
        /// <param name="tags"> Deployment stack resource tags. </param>
        /// <param name="error"> The error detail. </param>
        /// <param name="template"> The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both. </param>
        /// <param name="templateLink"> The URI of the template. Use either the templateLink property or the template property, but not both. </param>
        /// <param name="parameters"> Name and value pairs that define the deployment parameters for the template. Use this element when providing the parameter values directly in the request, rather than linking to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. </param>
        /// <param name="parametersLink"> The URI of parameters file. Use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both. </param>
        /// <param name="actionOnUnmanage"> Defines the behavior of resources that are no longer managed after the Deployment stack is updated or deleted. </param>
        /// <param name="debugSettingDetailLevel"> The debug setting of the deployment. </param>
        /// <param name="bypassStackOutOfSyncError"> Flag to bypass service errors that indicate the stack resource list is not correctly synchronized. </param>
        /// <param name="deploymentScope"> The scope at which the initial deployment should be created. If a scope is not specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'). </param>
        /// <param name="description"> Deployment stack description. Max length of 4096 characters. </param>
        /// <param name="denySettings"> Defines how resources deployed by the stack are locked. </param>
        /// <param name="provisioningState"> State of the deployment stack. </param>
        /// <param name="correlationId"> The correlation id of the last Deployment stack upsert or delete operation. It is in GUID format and is used for tracing. </param>
        /// <param name="detachedResources"> An array of resources that were detached during the most recent Deployment stack update. Detached means that the resource was removed from the template, but no relevant deletion operations were specified. So, the resource still exists while no longer being associated with the stack. </param>
        /// <param name="deletedResources"> An array of resources that were deleted during the most recent Deployment stack update. Deleted means that the resource was removed from the template and relevant deletion operations were specified. </param>
        /// <param name="failedResources"> An array of resources that failed to reach goal state during the most recent update. Each resourceId is accompanied by an error message. </param>
        /// <param name="resources"> An array of resources currently managed by the deployment stack. </param>
        /// <param name="deploymentId"> The resourceId of the deployment resource created by the deployment stack. </param>
        /// <param name="outputs"> The outputs of the deployment resource created by the deployment stack. </param>
        /// <param name="duration"> The duration of the last successful Deployment stack update. </param>
        /// <returns> A new <see cref="Resources.DeploymentStackData"/> instance for mocking. </returns>
        public static DeploymentStackData DeploymentStackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ResponseError error = null, BinaryData template = null, DeploymentStacksTemplateLink templateLink = null, IDictionary<string, DeploymentParameter> parameters = null, DeploymentStacksParametersLink parametersLink = null, ActionOnUnmanage actionOnUnmanage = null, string debugSettingDetailLevel = null, bool? bypassStackOutOfSyncError = null, string deploymentScope = null, string description = null, DenySettings denySettings = null, DeploymentStackProvisioningState? provisioningState = null, string correlationId = null, IEnumerable<SubResource> detachedResources = null, IEnumerable<SubResource> deletedResources = null, IEnumerable<ResourceReferenceExtended> failedResources = null, IEnumerable<ManagedResourceReference> resources = null, string deploymentId = null, BinaryData outputs = null, TimeSpan? duration = null)
        {
            tags ??= new Dictionary<string, string>();
            parameters ??= new Dictionary<string, DeploymentParameter>();
            detachedResources ??= new List<SubResource>();
            deletedResources ??= new List<SubResource>();
            failedResources ??= new List<ResourceReferenceExtended>();
            resources ??= new List<ManagedResourceReference>();

            return new DeploymentStackData(
                id,
                name,
                resourceType,
                systemData,
                location,
                tags,
                error,
                template,
                templateLink,
                parameters,
                parametersLink,
                actionOnUnmanage,
                debugSettingDetailLevel != null ? new DeploymentStacksDebugSetting(debugSettingDetailLevel, serializedAdditionalRawData: null) : null,
                bypassStackOutOfSyncError,
                deploymentScope,
                description,
                denySettings,
                provisioningState,
                correlationId,
                detachedResources?.ToList(),
                deletedResources?.ToList(),
                failedResources?.ToList(),
                resources?.ToList(),
                deploymentId,
                outputs,
                duration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceReferenceAutoGenerated"/>. </summary>
        /// <param name="id"> The resourceId of a resource managed by the deployment stack. </param>
        /// <returns> A new <see cref="Models.ResourceReferenceAutoGenerated"/> instance for mocking. </returns>
        public static ResourceReferenceAutoGenerated ResourceReferenceAutoGenerated(string id = null)
        {
            return new ResourceReferenceAutoGenerated(id, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceReferenceExtended"/>. </summary>
        /// <param name="id"> The resourceId of a resource managed by the deployment stack. </param>
        /// <param name="error"> The error detail. </param>
        /// <returns> A new <see cref="Models.ResourceReferenceExtended"/> instance for mocking. </returns>
        public static ResourceReferenceExtended ResourceReferenceExtended(string id = null, ResponseError error = null)
        {
            return new ResourceReferenceExtended(id, serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedResourceReference"/>. </summary>
        /// <param name="id"> The resourceId of a resource managed by the deployment stack. </param>
        /// <param name="status"> Current management state of the resource in the deployment stack. </param>
        /// <param name="denyStatus"> denyAssignment settings applied to the resource. </param>
        /// <returns> A new <see cref="Models.ManagedResourceReference"/> instance for mocking. </returns>
        public static ManagedResourceReference ManagedResourceReference(string id = null, ResourceStatusMode? status = null, DenyStatusMode? denyStatus = null)
        {
            return new ManagedResourceReference(id, serializedAdditionalRawData: null, status, denyStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DeploymentStackValidateResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The validation result details. </param>
        /// <param name="error"> The error detail. </param>
        /// <returns> A new <see cref="Models.DeploymentStackValidateResult"/> instance for mocking. </returns>
        public static DeploymentStackValidateResult DeploymentStackValidateResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DeploymentStackValidateProperties properties = null, ResponseError error = null)
        {
            return new DeploymentStackValidateResult(
                id,
                name,
                resourceType,
                systemData,
                properties,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Resources.DataBoundaryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Data boundary properties. </param>
        /// <returns> A new <see cref="Resources.DataBoundaryData"/> instance for mocking. </returns>
        public static DataBoundaryData DataBoundaryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataBoundaryProperties properties = null)
        {
            return new DataBoundaryData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoundaryProperties"/>. </summary>
        /// <param name="dataBoundary"> The data boundary definition. </param>
        /// <param name="provisioningState"> Denotes the state of provisioning. </param>
        /// <returns> A new <see cref="Models.DataBoundaryProperties"/> instance for mocking. </returns>
        public static DataBoundaryProperties DataBoundaryProperties(DataBoundaryRegion? dataBoundary = null, DataBoundaryProvisioningState? provisioningState = null)
        {
            return new DataBoundaryProperties(dataBoundary, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzurePowerShellScript"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="identity"> Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported. </param>
        /// <param name="location"> The location of the ACI and the storage account for the deployment script. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="containerGroupName"> Container settings. </param>
        /// <param name="storageAccountSettings"> Storage Account settings. </param>
        /// <param name="cleanupPreference"> The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'. </param>
        /// <param name="provisioningState"> State of the script execution. This only appears in the response. </param>
        /// <param name="status"> Contains the results of script execution. </param>
        /// <param name="outputs"> List of script outputs. </param>
        /// <param name="primaryScriptUri"> Uri for the script. This is the entry point for the external script. </param>
        /// <param name="supportingScriptUris"> Supporting files for the external script. </param>
        /// <param name="scriptContent"> Script body. </param>
        /// <param name="arguments"> Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'. </param>
        /// <param name="environmentVariables"> The environment variables to pass over to the script. </param>
        /// <param name="forceUpdateTag"> Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. </param>
        /// <param name="retentionInterval"> Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day). </param>
        /// <param name="timeout"> Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D. </param>
        /// <param name="azPowerShellVersion"> Azure PowerShell module version to be used. </param>
        /// <returns> A new <see cref="Models.AzurePowerShellScript"/> instance for mocking. </returns>
        public static AzurePowerShellScript AzurePowerShellScript(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ArmDeploymentScriptManagedIdentity identity = null, AzureLocation location = default, IDictionary<string, string> tags = null, string containerGroupName = null, ScriptStorageConfiguration storageAccountSettings = null, ScriptCleanupOptions? cleanupPreference = null, ScriptProvisioningState? provisioningState = null, ScriptStatus status = null, BinaryData outputs = null, Uri primaryScriptUri = null, IEnumerable<Uri> supportingScriptUris = null, string scriptContent = null, string arguments = null, IEnumerable<ScriptEnvironmentVariable> environmentVariables = null, string forceUpdateTag = null, TimeSpan retentionInterval = default, TimeSpan? timeout = null, string azPowerShellVersion = null)
        {
            tags ??= new Dictionary<string, string>();
            supportingScriptUris ??= new List<Uri>();
            environmentVariables ??= new List<ScriptEnvironmentVariable>();

            return new AzurePowerShellScript(
                id,
                name,
                resourceType,
                systemData,
                identity,
                location,
                tags,
                ScriptType.AzurePowerShell,
                serializedAdditionalRawData: null,
                containerGroupName != null ? new ContainerConfiguration(containerGroupName, serializedAdditionalRawData: null) : null,
                storageAccountSettings,
                cleanupPreference,
                provisioningState,
                status,
                outputs,
                primaryScriptUri,
                supportingScriptUris?.ToList(),
                scriptContent,
                arguments,
                environmentVariables?.ToList(),
                forceUpdateTag,
                retentionInterval,
                timeout,
                azPowerShellVersion);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScriptStatus"/>. </summary>
        /// <param name="containerInstanceId"> ACI resource Id. </param>
        /// <param name="storageAccountId"> Storage account resource Id. </param>
        /// <param name="startOn"> Start time of the script execution. </param>
        /// <param name="endOn"> End time of the script execution. </param>
        /// <param name="expireOn"> Time the deployment script resource will expire. </param>
        /// <param name="error"> Error that is relayed from the script execution. </param>
        /// <returns> A new <see cref="Models.ScriptStatus"/> instance for mocking. </returns>
        public static ScriptStatus ScriptStatus(string containerInstanceId = null, string storageAccountId = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, DateTimeOffset? expireOn = null, ResponseError error = null)
        {
            return new ScriptStatus(
                containerInstanceId,
                storageAccountId,
                startOn,
                endOn,
                expireOn,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureCliScript"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="identity"> Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported. </param>
        /// <param name="location"> The location of the ACI and the storage account for the deployment script. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="containerGroupName"> Container settings. </param>
        /// <param name="storageAccountSettings"> Storage Account settings. </param>
        /// <param name="cleanupPreference"> The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'. </param>
        /// <param name="provisioningState"> State of the script execution. This only appears in the response. </param>
        /// <param name="status"> Contains the results of script execution. </param>
        /// <param name="outputs"> List of script outputs. </param>
        /// <param name="primaryScriptUri"> Uri for the script. This is the entry point for the external script. </param>
        /// <param name="supportingScriptUris"> Supporting files for the external script. </param>
        /// <param name="scriptContent"> Script body. </param>
        /// <param name="arguments"> Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'. </param>
        /// <param name="environmentVariables"> The environment variables to pass over to the script. </param>
        /// <param name="forceUpdateTag"> Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. </param>
        /// <param name="retentionInterval"> Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day). </param>
        /// <param name="timeout"> Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D. </param>
        /// <param name="azCliVersion"> Azure CLI module version to be used. </param>
        /// <returns> A new <see cref="Models.AzureCliScript"/> instance for mocking. </returns>
        public static AzureCliScript AzureCliScript(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ArmDeploymentScriptManagedIdentity identity = null, AzureLocation location = default, IDictionary<string, string> tags = null, string containerGroupName = null, ScriptStorageConfiguration storageAccountSettings = null, ScriptCleanupOptions? cleanupPreference = null, ScriptProvisioningState? provisioningState = null, ScriptStatus status = null, BinaryData outputs = null, Uri primaryScriptUri = null, IEnumerable<Uri> supportingScriptUris = null, string scriptContent = null, string arguments = null, IEnumerable<ScriptEnvironmentVariable> environmentVariables = null, string forceUpdateTag = null, TimeSpan retentionInterval = default, TimeSpan? timeout = null, string azCliVersion = null)
        {
            tags ??= new Dictionary<string, string>();
            supportingScriptUris ??= new List<Uri>();
            environmentVariables ??= new List<ScriptEnvironmentVariable>();

            return new AzureCliScript(
                id,
                name,
                resourceType,
                systemData,
                identity,
                location,
                tags,
                ScriptType.AzureCLI,
                serializedAdditionalRawData: null,
                containerGroupName != null ? new ContainerConfiguration(containerGroupName, serializedAdditionalRawData: null) : null,
                storageAccountSettings,
                cleanupPreference,
                provisioningState,
                status,
                outputs,
                primaryScriptUri,
                supportingScriptUris?.ToList(),
                scriptContent,
                arguments,
                environmentVariables?.ToList(),
                forceUpdateTag,
                retentionInterval,
                timeout,
                azCliVersion);
        }
    }
}
