// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A class representing the ArmApplicationDefinition data model.
    /// Information about managed application definition.
    /// </summary>
    public partial class ArmApplicationDefinitionData : ArmApplicationResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ArmApplicationDefinitionData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="lockLevel"> The managed application lock level. </param>
        public ArmApplicationDefinitionData(AzureLocation location, ArmApplicationLockLevel lockLevel) : base(location)
        {
            LockLevel = lockLevel;
            Authorizations = new ChangeTrackingList<ArmApplicationAuthorization>();
            Artifacts = new ChangeTrackingList<ArmApplicationDefinitionArtifact>();
            Policies = new ChangeTrackingList<ArmApplicationPolicy>();
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="managedBy"> ID of the resource that manages this resource. </param>
        /// <param name="sku"> The SKU of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="lockLevel"> The managed application lock level. </param>
        /// <param name="displayName"> The managed application definition display name. </param>
        /// <param name="isEnabled"> A value indicating whether the package is enabled or not. </param>
        /// <param name="authorizations"> The managed application provider authorizations. </param>
        /// <param name="artifacts"> The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition. </param>
        /// <param name="description"> The managed application definition description. </param>
        /// <param name="packageFileUri"> The managed application definition package file Uri. Use this element. </param>
        /// <param name="mainTemplate"> The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string. </param>
        /// <param name="createUiDefinition"> The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string. </param>
        /// <param name="notificationPolicy"> The managed application notification policy. </param>
        /// <param name="lockingPolicy"> The managed application locking policy. </param>
        /// <param name="deploymentPolicy"> The managed application deployment policy. </param>
        /// <param name="managementPolicy"> The managed application management policy that determines publisher's access to the managed resource group. </param>
        /// <param name="policies"> The managed application provider policies. </param>
        internal ArmApplicationDefinitionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string managedBy, ArmApplicationSku sku, IDictionary<string, BinaryData> serializedAdditionalRawData, ArmApplicationLockLevel lockLevel, string displayName, bool? isEnabled, IList<ArmApplicationAuthorization> authorizations, IList<ArmApplicationDefinitionArtifact> artifacts, string description, Uri packageFileUri, BinaryData mainTemplate, BinaryData createUiDefinition, ArmApplicationNotificationPolicy notificationPolicy, ArmApplicationPackageLockingPolicy lockingPolicy, ArmApplicationDeploymentPolicy deploymentPolicy, ArmApplicationManagementPolicy managementPolicy, IList<ArmApplicationPolicy> policies) : base(id, name, resourceType, systemData, tags, location, managedBy, sku, serializedAdditionalRawData)
        {
            LockLevel = lockLevel;
            DisplayName = displayName;
            IsEnabled = isEnabled;
            Authorizations = authorizations;
            Artifacts = artifacts;
            Description = description;
            PackageFileUri = packageFileUri;
            MainTemplate = mainTemplate;
            CreateUiDefinition = createUiDefinition;
            NotificationPolicy = notificationPolicy;
            LockingPolicy = lockingPolicy;
            DeploymentPolicy = deploymentPolicy;
            ManagementPolicy = managementPolicy;
            Policies = policies;
        }

        /// <summary> Initializes a new instance of <see cref="ArmApplicationDefinitionData"/> for deserialization. </summary>
        internal ArmApplicationDefinitionData()
        {
        }

        /// <summary> The managed application lock level. </summary>
        [WirePath("properties.lockLevel")]
        public ArmApplicationLockLevel LockLevel { get; set; }
        /// <summary> The managed application definition display name. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> A value indicating whether the package is enabled or not. </summary>
        [WirePath("properties.isEnabled")]
        public bool? IsEnabled { get; set; }
        /// <summary> The managed application provider authorizations. </summary>
        [WirePath("properties.authorizations")]
        public IList<ArmApplicationAuthorization> Authorizations { get; }
        /// <summary> The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition. </summary>
        [WirePath("properties.artifacts")]
        public IList<ArmApplicationDefinitionArtifact> Artifacts { get; }
        /// <summary> The managed application definition description. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The managed application definition package file Uri. Use this element. </summary>
        [WirePath("properties.packageFileUri")]
        public Uri PackageFileUri { get; set; }
        /// <summary>
        /// The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties.mainTemplate")]
        public BinaryData MainTemplate { get; set; }
        /// <summary>
        /// The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties.createUiDefinition")]
        public BinaryData CreateUiDefinition { get; set; }
        /// <summary> The managed application notification policy. </summary>
        internal ArmApplicationNotificationPolicy NotificationPolicy { get; set; }
        /// <summary> The managed application notification endpoint. </summary>
        [WirePath("properties.notificationPolicy.notificationEndpoints")]
        public IList<ArmApplicationNotificationEndpoint> NotificationEndpoints
        {
            get => NotificationPolicy is null ? default : NotificationPolicy.NotificationEndpoints;
            set => NotificationPolicy = new ArmApplicationNotificationPolicy(value);
        }

        /// <summary> The managed application locking policy. </summary>
        [WirePath("properties.lockingPolicy")]
        public ArmApplicationPackageLockingPolicy LockingPolicy { get; set; }
        /// <summary> The managed application deployment policy. </summary>
        internal ArmApplicationDeploymentPolicy DeploymentPolicy { get; set; }

        /// <summary> The managed application management policy that determines publisher's access to the managed resource group. </summary>
        internal ArmApplicationManagementPolicy ManagementPolicy { get; set; }
        /// <summary> The managed application management mode. </summary>
        [WirePath("properties.managementPolicy.mode")]
        public ArmApplicationManagementMode? ManagementMode
        {
            get => ManagementPolicy is null ? default : ManagementPolicy.Mode;
            set
            {
                if (ManagementPolicy is null)
                    ManagementPolicy = new ArmApplicationManagementPolicy();
                ManagementPolicy.Mode = value;
            }
        }

        /// <summary> The managed application provider policies. </summary>
        [WirePath("properties.policies")]
        public IList<ArmApplicationPolicy> Policies { get; }
    }
}
