// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_TemplateSpecVersionResource
    {
        // TemplateSpecsPatch
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TemplateSpecsPatch()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2021-05-01/examples/TemplateSpecVersionsPatch.json
            // this example is just showing the usage of "TemplateSpecVersions_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TemplateSpecVersionResource created on azure
            // for more information of creating TemplateSpecVersionResource, please refer to the document of TemplateSpecVersionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "templateSpecRG";
            string templateSpecName = "simpleTemplateSpec";
            string templateSpecVersion = "v1.0";
            ResourceIdentifier templateSpecVersionResourceId = TemplateSpecVersionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, templateSpecName, templateSpecVersion);
            TemplateSpecVersionResource templateSpecVersion0 = client.GetTemplateSpecVersionResource(templateSpecVersionResourceId);

            // invoke the operation
            TemplateSpecVersionPatch patch = new TemplateSpecVersionPatch()
            {
                Tags =
{
["myTag"] = "My Value",
},
            };
            TemplateSpecVersionResource result = await templateSpecVersion0.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TemplateSpecVersionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TemplateSpecVersionsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_TemplateSpecVersionsGet()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2021-05-01/examples/TemplateSpecVersionsGet.json
            // this example is just showing the usage of "TemplateSpecVersions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TemplateSpecVersionResource created on azure
            // for more information of creating TemplateSpecVersionResource, please refer to the document of TemplateSpecVersionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "templateSpecRG";
            string templateSpecName = "simpleTemplateSpec";
            string templateSpecVersion = "v1.0";
            ResourceIdentifier templateSpecVersionResourceId = TemplateSpecVersionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, templateSpecName, templateSpecVersion);
            TemplateSpecVersionResource templateSpecVersion0 = client.GetTemplateSpecVersionResource(templateSpecVersionResourceId);

            // invoke the operation
            TemplateSpecVersionResource result = await templateSpecVersion0.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TemplateSpecVersionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TemplateSpecVersionsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_TemplateSpecVersionsDelete()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2021-05-01/examples/TemplateSpecVersionsDelete.json
            // this example is just showing the usage of "TemplateSpecVersions_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TemplateSpecVersionResource created on azure
            // for more information of creating TemplateSpecVersionResource, please refer to the document of TemplateSpecVersionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "templateSpecRG";
            string templateSpecName = "simpleTemplateSpec";
            string templateSpecVersion = "v1.0";
            ResourceIdentifier templateSpecVersionResourceId = TemplateSpecVersionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, templateSpecName, templateSpecVersion);
            TemplateSpecVersionResource templateSpecVersion0 = client.GetTemplateSpecVersionResource(templateSpecVersionResourceId);

            // invoke the operation
            await templateSpecVersion0.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
