// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_TemplateSpecResource
    {
        // TemplateSpecsPatch
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TemplateSpecsPatch()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2021-05-01/examples/TemplateSpecsPatch.json
            // this example is just showing the usage of "TemplateSpecs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TemplateSpecResource created on azure
            // for more information of creating TemplateSpecResource, please refer to the document of TemplateSpecResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "templateSpecRG";
            string templateSpecName = "simpleTemplateSpec";
            ResourceIdentifier templateSpecResourceId = TemplateSpecResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, templateSpecName);
            TemplateSpecResource templateSpec = client.GetTemplateSpecResource(templateSpecResourceId);

            // invoke the operation
            TemplateSpecPatch patch = new TemplateSpecPatch()
            {
                Tags =
{
["myTag"] = "My Value",
},
            };
            TemplateSpecResource result = await templateSpec.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TemplateSpecData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TemplateSpecsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_TemplateSpecsGet()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2021-05-01/examples/TemplateSpecsGet.json
            // this example is just showing the usage of "TemplateSpecs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TemplateSpecResource created on azure
            // for more information of creating TemplateSpecResource, please refer to the document of TemplateSpecResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "templateSpecRG";
            string templateSpecName = "simpleTemplateSpec";
            ResourceIdentifier templateSpecResourceId = TemplateSpecResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, templateSpecName);
            TemplateSpecResource templateSpec = client.GetTemplateSpecResource(templateSpecResourceId);

            // invoke the operation
            TemplateSpecResource result = await templateSpec.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TemplateSpecData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TemplateSpecsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_TemplateSpecsDelete()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2021-05-01/examples/TemplateSpecsDelete.json
            // this example is just showing the usage of "TemplateSpecs_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TemplateSpecResource created on azure
            // for more information of creating TemplateSpecResource, please refer to the document of TemplateSpecResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "templateSpecRG";
            string templateSpecName = "simpleTemplateSpec";
            ResourceIdentifier templateSpecResourceId = TemplateSpecResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, templateSpecName);
            TemplateSpecResource templateSpec = client.GetTemplateSpecResource(templateSpecResourceId);

            // invoke the operation
            await templateSpec.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // TemplatesSpecsListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetTemplateSpecs_TemplatesSpecsListBySubscription()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2021-05-01/examples/TemplateSpecsListBySubscription.json
            // this example is just showing the usage of "TemplateSpecs_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (TemplateSpecResource item in subscriptionResource.GetTemplateSpecsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                TemplateSpecData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
