// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_SubscriptionResourceExtensions
    {
        // Decompile an ARM json template into a Bicep file
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task BicepDecompile_DecompileAnARMJsonTemplateIntoABicepFile()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2023-11-01/examples/DecompileBicep.json
            // this example is just showing the usage of "Decompile_Bicep" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            DecompileOperationContent content = new DecompileOperationContent("{\r\n \"$schema\": \"https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#\",\r\n \"contentVersion\": \"1.0.0.0\",\r\n \"metadata\": {\r\n \"_generator\": {\r\n \"name\": \"bicep\",\r\n \"version\": \"0.15.31.15270\",\r\n \"templateHash\": \"9249505596133208719\"\r\n }\r\n },\r\n \"parameters\": {\r\n \"storageAccountName\": {\r\n \"type\": \"string\"\r\n }\r\n },\r\n \"resources\": []\r\n}");
            DecompileOperationSuccessResult result = await subscriptionResource.BicepDecompileAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
