// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_DataBoundaryCollection
    {
        // Get data boundary at scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDataBoundaryAtScope()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2024-08-01/examples/GetScopedDataBoundary.json
            // this example is just showing the usage of "DataBoundaries_GetScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this DataBoundaryResource
            string scope = "subscriptions/11111111-1111-1111-1111-111111111111/resourcegroups/my-resource-group";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            DataBoundaryCollection collection = client.GetDataBoundaries(scopeId);

            // invoke the operation
            DataBoundaryName name = DataBoundaryName.Default;
            DataBoundaryResource result = await collection.GetAsync(name);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoundaryData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get data boundary at scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetDataBoundaryAtScope()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2024-08-01/examples/GetScopedDataBoundary.json
            // this example is just showing the usage of "DataBoundaries_GetScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this DataBoundaryResource
            string scope = "subscriptions/11111111-1111-1111-1111-111111111111/resourcegroups/my-resource-group";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            DataBoundaryCollection collection = client.GetDataBoundaries(scopeId);

            // invoke the operation
            DataBoundaryName name = DataBoundaryName.Default;
            bool result = await collection.ExistsAsync(name);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get data boundary at scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetDataBoundaryAtScope()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2024-08-01/examples/GetScopedDataBoundary.json
            // this example is just showing the usage of "DataBoundaries_GetScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this DataBoundaryResource
            string scope = "subscriptions/11111111-1111-1111-1111-111111111111/resourcegroups/my-resource-group";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            DataBoundaryCollection collection = client.GetDataBoundaries(scopeId);

            // invoke the operation
            DataBoundaryName name = DataBoundaryName.Default;
            NullableResponse<DataBoundaryResource> response = await collection.GetIfExistsAsync(name);
            DataBoundaryResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataBoundaryData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
