// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_ArmDeploymentScriptResource
    {
        // DeploymentScriptsUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_DeploymentScriptsUpdate()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Update.json
            // this example is just showing the usage of "DeploymentScripts_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmDeploymentScriptResource created on azure
            // for more information of creating ArmDeploymentScriptResource, please refer to the document of ArmDeploymentScriptResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "script-rg";
            string scriptName = "MyDeploymentScript";
            ResourceIdentifier armDeploymentScriptResourceId = ArmDeploymentScriptResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, scriptName);
            ArmDeploymentScriptResource armDeploymentScript = client.GetArmDeploymentScriptResource(armDeploymentScriptResourceId);

            // invoke the operation
            ArmDeploymentScriptPatch patch = new ArmDeploymentScriptPatch()
            {
                Tags =
{
},
            };
            ArmDeploymentScriptResource result = await armDeploymentScript.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArmDeploymentScriptData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeploymentScriptsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DeploymentScriptsGet()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Get.json
            // this example is just showing the usage of "DeploymentScripts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmDeploymentScriptResource created on azure
            // for more information of creating ArmDeploymentScriptResource, please refer to the document of ArmDeploymentScriptResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "script-rg";
            string scriptName = "MyDeploymentScript";
            ResourceIdentifier armDeploymentScriptResourceId = ArmDeploymentScriptResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, scriptName);
            ArmDeploymentScriptResource armDeploymentScript = client.GetArmDeploymentScriptResource(armDeploymentScriptResourceId);

            // invoke the operation
            ArmDeploymentScriptResource result = await armDeploymentScript.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArmDeploymentScriptData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeploymentScriptsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeploymentScriptsDelete()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Delete.json
            // this example is just showing the usage of "DeploymentScripts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmDeploymentScriptResource created on azure
            // for more information of creating ArmDeploymentScriptResource, please refer to the document of ArmDeploymentScriptResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "script-rg";
            string scriptName = "MyDeploymentScript";
            ResourceIdentifier armDeploymentScriptResourceId = ArmDeploymentScriptResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, scriptName);
            ArmDeploymentScriptResource armDeploymentScript = client.GetArmDeploymentScriptResource(armDeploymentScriptResourceId);

            // invoke the operation
            await armDeploymentScript.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // DeploymentScriptsListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetArmDeploymentScripts_DeploymentScriptsListBySubscription()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_ListBySubscription.json
            // this example is just showing the usage of "DeploymentScripts_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (ArmDeploymentScriptResource item in subscriptionResource.GetArmDeploymentScriptsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArmDeploymentScriptData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // DeploymentScriptsGetLogs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLogs_DeploymentScriptsGetLogs()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_GetLogs.json
            // this example is just showing the usage of "DeploymentScripts_GetLogs" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmDeploymentScriptResource created on azure
            // for more information of creating ArmDeploymentScriptResource, please refer to the document of ArmDeploymentScriptResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "script-rg";
            string scriptName = "MyDeploymentScript";
            ResourceIdentifier armDeploymentScriptResourceId = ArmDeploymentScriptResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, scriptName);
            ArmDeploymentScriptResource armDeploymentScript = client.GetArmDeploymentScriptResource(armDeploymentScriptResourceId);

            // invoke the operation and iterate over the result
            await foreach (ScriptLogResource item in armDeploymentScript.GetLogsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ScriptLogData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
