// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_ArmApplicationResource
    {
        // Get a managed application
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAManagedApplication()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Solutions/stable/2019-07-01/examples/getApplication.json
            // this example is just showing the usage of "Applications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmApplicationResource created on azure
            // for more information of creating ArmApplicationResource, please refer to the document of ArmApplicationResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string applicationName = "myManagedApplication";
            ResourceIdentifier armApplicationResourceId = ArmApplicationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, applicationName);
            ArmApplicationResource armApplication = client.GetArmApplicationResource(armApplicationResourceId);

            // invoke the operation
            ArmApplicationResource result = await armApplication.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArmApplicationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update managed application
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateManagedApplication()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Solutions/stable/2019-07-01/examples/updateApplication.json
            // this example is just showing the usage of "Applications_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmApplicationResource created on azure
            // for more information of creating ArmApplicationResource, please refer to the document of ArmApplicationResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string applicationName = "myManagedApplication";
            ResourceIdentifier armApplicationResourceId = ArmApplicationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, applicationName);
            ArmApplicationResource armApplication = client.GetArmApplicationResource(armApplicationResourceId);

            // invoke the operation
            ArmApplicationPatch patch = new ArmApplicationPatch(new AzureLocation("placeholder"))
            {
                Kind = "ServiceCatalog",
                ManagedResourceGroupId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/myManagedRG"),
                ApplicationDefinitionId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Solutions/applicationDefinitions/myAppDef"),
            };
            ArmApplicationResource result = await armApplication.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArmApplicationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
