# Release History

## 1.10.0-beta.1 (Unreleased)

### Features Added

- Exposed `JsonModelWriteCore` for model serialization procedure.

### Breaking Changes

### Bugs Fixed

### Other Changes

## 1.9.0 (2024-09-24)

### Features Added

- Added `DataBoundary` support.

## 1.8.0 (2024-07-04)

### Features Added

- Added `DeploymentStack` support.

## 1.7.3 (2024-05-07)

### Bugs Fixed

- Fixed bicep serialization of flattened properties.

## 1.7.2 (2024-04-29)

### Features Added

- Added `ArmOperation.Rehydrate` and `ArmOperation.Rehydrate<T>` static methods to rehydrate a long-running operation.

## 1.7.1 (2024-03-23)

### Features Added

- Enabled the new model serialization by using the System.ClientModel, refer this [document](https://aka.ms/azsdk/net/mrw) for more details.
- Added experimental Bicep serialization.

## 1.7.0 (2023-11-16)

### Features Added

- Enable mocking for extension methods, refer this [document](https://aka.ms/azsdk/net/mocking) for more details.

### Other Changes

- Upgraded Azure.Core from 1.35.0 to 1.36.0
- Upgraded Azure.ResourceManager from 1.6.0 to 1.9.0

## 1.7.0-beta.1 (2023-08-14)

### Features Added

- Make `ResourcesArmClientMockingExtension`, `ResourcesManagementGroupMockingExtension`, `ResourcesResourceGroupMockingExtension`, `ResourcesSubscriptionMockingExtension` and `ResourcesTenantMockingExtension` public for mocking the extension methods.

## 1.6.0 (2023-05-31)

### Features Added

- Enable the model factory feature for model mocking, more information can be found [here](https://azure.github.io/azure-sdk/dotnet_introduction.html#dotnet-mocking-factory-builder).

### Other Changes

- Upgraded dependent Azure.Core to 1.32.0.
- Upgraded dependent Azure.ResourceManager to 1.6.0.

## 1.4.0 (2023-02-13)

### Other Changes

- Upgraded resources API version to `2022-09-01`.

## 1.3.1 (2022-11-11)

### Other Changes

- Minor internal changes.
- Polished the README and CHANGELOG files.

## 1.3.0 (2022-08-09)

### Other Changes

- Added `ExpireOn` property in `ScriptStatus` model to replace `ExpirationOn` property and made `ExpirationOn` EditorBrowsableNever.

## 1.2.0 (2022-07-11)

### Other Changes

- Upgraded dependent `Azure.Core` to 1.25.0
- Upgraded dependent `Azure.ResourceManager` to 1.2.0

## 1.1.0 (2022-06-08)

### Features Added

- Add Update methods in resource classes.

## 1.0.0 (2022-04-07)
This package is the first stable release of the Azure Resources management library.

### Breaking Changes

Minor changes since the public beta release:
- All `Tag` methods have been removed from `SubscriptionResource` as the service doesn't support these operations.
- Simplify `type` property names.
- Normalized the body parameter type names for PUT / POST / PATCH operations if it's only used as input.
- Tweaked some properties to right type.

## 1.0.0-beta.7 (2022-03-31)

### Breaking Changes

- Now all the resource classes would have a `Resource` suffix (if it previously doesn't have one).
- Renamed some models to more comprehensive names.
- `bool waitForCompletion` parameter in all long running operations were changed to `WaitUntil waitUntil`.
- Removed `GetIfExists` methods from all the resource classes.
- All properties of the type `object` were changed to `BinaryData`.

## 1.0.0-beta.6 (2022-01-29)

### Breaking Changes

- waitForCompletion is now a required parameter and moved to the first parameter in LRO operations.
- Renaming: JitRequestDefinition renamed to JitRequest, IdentityAutoGenerated renamed to ApplicationManagedIdentity, SkuAutoGenerated renamed to ApplicationSku.
- Removed GetAllAsGenericResources in [Resource]Collections.
- Added Resource constructor to use ArmClient for ClientContext information and removed previous constructors with parameters.

## 1.0.0-beta.5 (2021-12-28)

### Features Added

- Added `CreateResourceIdentifier` for each resource class

### Breaking Changes

- Renamed `CheckIfExists` to `Exists` for each resource collection class
- Renamed `Get{Resource}ByName` to `Get{Resource}AsGenericResources` in `SubscriptionExtensions`

## 1.0.0-beta.4 (2021-12-07)

### Breaking Changes

- Unified the identification rule of detecting resources, therefore some resources might become non-resources, and vice versa.

### Bugs Fixed

- Fixed problematic internal parameter invocation from the context `Id` property to the corresponding `RestOperations`.

## 1.0.0-beta.3 (2021-10-28)

### Breaking Changes

- Renamed [Resource]Container to [Resource]Collection and added the IEnumerable<T> and IAsyncEnumerable<T> interfaces to them making it easier to iterate over the list in the simple case.

## 1.0.0-beta.2 (2021-09-14)

### Features Added

- Added ArmClient extension methods to support [start from the middle scenario](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/resourcemanager/Azure.ResourceManager#managing-existing-resources-by-id)
- Added Template Spec.

## 1.0.0-beta.1 (2021-08-31)

### General New Features

This package follows the [new Azure SDK guidelines](https://azure.github.io/azure-sdk/general_introduction.html), and provides many core capabilities:

    - Support MSAL.NET, Azure.Identity is out of box for supporting MSAL.NET.
    - Support [OpenTelemetry](https://opentelemetry.io/) for distributed tracing.
    - HTTP pipeline with custom policies.
    - Better error-handling.
    - Support uniform telemetry across all languages.

This package is a Public Preview version, so expect incompatible changes in subsequent releases as we improve the product. To provide feedback, submit an issue in our [Azure SDK for .NET GitHub repo](https://github.com/Azure/azure-sdk-for-net/issues).

> NOTE: For more information about unified authentication, please refer to [Microsoft Azure Identity documentation for .NET](https://docs.microsoft.com//dotnet/api/overview/azure/identity-readme?view=azure-dotnet).
