// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines the virtual network subnets resource settings. </summary>
    public partial class SubnetResourceSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SubnetResourceSettings"/>. </summary>
        public SubnetResourceSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SubnetResourceSettings"/>. </summary>
        /// <param name="name"> Gets or sets the Subnet name. </param>
        /// <param name="addressPrefix"> Gets or sets address prefix for the subnet. </param>
        /// <param name="networkSecurityGroup"> Defines reference to NSG. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SubnetResourceSettings(string name, string addressPrefix, NetworkSecurityGroupResourceReferenceInfo networkSecurityGroup, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AddressPrefix = addressPrefix;
            NetworkSecurityGroup = networkSecurityGroup;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the Subnet name. </summary>
        public string Name { get; set; }
        /// <summary> Gets or sets address prefix for the subnet. </summary>
        public string AddressPrefix { get; set; }
        /// <summary> Defines reference to NSG. </summary>
        internal NetworkSecurityGroupResourceReferenceInfo NetworkSecurityGroup { get; set; }
        /// <summary> Gets the ARM resource ID of the tracked resource being referenced. </summary>
        public ResourceIdentifier NetworkSecurityGroupSourceArmResourceId
        {
            get => NetworkSecurityGroup is null ? default : NetworkSecurityGroup.SourceArmResourceId;
            set => NetworkSecurityGroup = new NetworkSecurityGroupResourceReferenceInfo(value);
        }
    }
}
