// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines NIC IP configuration properties. </summary>
    public partial class NicIPConfigurationResourceSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NicIPConfigurationResourceSettings"/>. </summary>
        public NicIPConfigurationResourceSettings()
        {
            LoadBalancerBackendAddressPools = new ChangeTrackingList<LoadBalancerBackendAddressPoolReferenceInfo>();
            LoadBalancerNatRules = new ChangeTrackingList<LoadBalancerNatRuleReferenceInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="NicIPConfigurationResourceSettings"/>. </summary>
        /// <param name="name"> Gets or sets the IP configuration name. </param>
        /// <param name="privateIPAddressStringValue"> Gets or sets the private IP address of the network interface IP Configuration. </param>
        /// <param name="privateIPAllocationMethod"> Gets or sets the private IP address allocation method. </param>
        /// <param name="subnet"> Defines reference to subnet. </param>
        /// <param name="isPrimary"> Gets or sets a value indicating whether this IP configuration is the primary. </param>
        /// <param name="loadBalancerBackendAddressPools"> Gets or sets the references of the load balancer backend address pools. </param>
        /// <param name="loadBalancerNatRules"> Gets or sets the references of the load balancer NAT rules. </param>
        /// <param name="publicIP"> Defines reference to a public IP. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NicIPConfigurationResourceSettings(string name, string privateIPAddressStringValue, string privateIPAllocationMethod, SubnetReferenceInfo subnet, bool? isPrimary, IList<LoadBalancerBackendAddressPoolReferenceInfo> loadBalancerBackendAddressPools, IList<LoadBalancerNatRuleReferenceInfo> loadBalancerNatRules, PublicIPReferenceInfo publicIP, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            PrivateIPAddressStringValue = privateIPAddressStringValue;
            PrivateIPAllocationMethod = privateIPAllocationMethod;
            Subnet = subnet;
            IsPrimary = isPrimary;
            LoadBalancerBackendAddressPools = loadBalancerBackendAddressPools;
            LoadBalancerNatRules = loadBalancerNatRules;
            PublicIP = publicIP;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the IP configuration name. </summary>
        public string Name { get; set; }
        /// <summary> Gets or sets the private IP address of the network interface IP Configuration. </summary>
        public string PrivateIPAddressStringValue { get; set; }
        /// <summary> Gets or sets the private IP address allocation method. </summary>
        public string PrivateIPAllocationMethod { get; set; }
        /// <summary> Defines reference to subnet. </summary>
        public SubnetReferenceInfo Subnet { get; set; }
        /// <summary> Gets or sets a value indicating whether this IP configuration is the primary. </summary>
        public bool? IsPrimary { get; set; }
        /// <summary> Gets or sets the references of the load balancer backend address pools. </summary>
        public IList<LoadBalancerBackendAddressPoolReferenceInfo> LoadBalancerBackendAddressPools { get; }
        /// <summary> Gets or sets the references of the load balancer NAT rules. </summary>
        public IList<LoadBalancerNatRuleReferenceInfo> LoadBalancerNatRules { get; }
        /// <summary> Defines reference to a public IP. </summary>
        internal PublicIPReferenceInfo PublicIP { get; set; }
        /// <summary> Gets the ARM resource ID of the tracked resource being referenced. </summary>
        public ResourceIdentifier PublicIPSourceArmResourceId
        {
            get => PublicIP is null ? default : PublicIP.SourceArmResourceId;
            set => PublicIP = new PublicIPReferenceInfo(value);
        }
    }
}
