// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines reference to NSG. </summary>
    internal partial class NetworkSecurityGroupResourceReferenceInfo : MoverResourceReferenceInfo
    {
        /// <summary> Initializes a new instance of <see cref="NetworkSecurityGroupResourceReferenceInfo"/>. </summary>
        /// <param name="sourceArmResourceId"> Gets the ARM resource ID of the tracked resource being referenced. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceArmResourceId"/> is null. </exception>
        public NetworkSecurityGroupResourceReferenceInfo(ResourceIdentifier sourceArmResourceId) : base(sourceArmResourceId)
        {
            Argument.AssertNotNull(sourceArmResourceId, nameof(sourceArmResourceId));
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityGroupResourceReferenceInfo"/>. </summary>
        /// <param name="sourceArmResourceId"> Gets the ARM resource ID of the tracked resource being referenced. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityGroupResourceReferenceInfo(ResourceIdentifier sourceArmResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(sourceArmResourceId, serializedAdditionalRawData)
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityGroupResourceReferenceInfo"/> for deserialization. </summary>
        internal NetworkSecurityGroupResourceReferenceInfo()
        {
        }
    }
}
