// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    public partial class MoverVirtualNetworkResourceSettings : IUtf8JsonSerializable, IJsonModel<MoverVirtualNetworkResourceSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MoverVirtualNetworkResourceSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MoverVirtualNetworkResourceSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverVirtualNetworkResourceSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoverVirtualNetworkResourceSettings)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsCollectionDefined(Tags))
            {
                if (Tags != null)
                {
                    writer.WritePropertyName("tags"u8);
                    writer.WriteStartObject();
                    foreach (var item in Tags)
                    {
                        writer.WritePropertyName(item.Key);
                        writer.WriteStringValue(item.Value);
                    }
                    writer.WriteEndObject();
                }
                else
                {
                    writer.WriteNull("tags");
                }
            }
            if (Optional.IsDefined(EnableDdosProtection))
            {
                if (EnableDdosProtection != null)
                {
                    writer.WritePropertyName("enableDdosProtection"u8);
                    writer.WriteBooleanValue(EnableDdosProtection.Value);
                }
                else
                {
                    writer.WriteNull("enableDdosProtection");
                }
            }
            if (Optional.IsCollectionDefined(AddressSpace))
            {
                if (AddressSpace != null)
                {
                    writer.WritePropertyName("addressSpace"u8);
                    writer.WriteStartArray();
                    foreach (var item in AddressSpace)
                    {
                        writer.WriteStringValue(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("addressSpace");
                }
            }
            if (Optional.IsCollectionDefined(DnsServers))
            {
                if (DnsServers != null)
                {
                    writer.WritePropertyName("dnsServers"u8);
                    writer.WriteStartArray();
                    foreach (var item in DnsServers)
                    {
                        writer.WriteStringValue(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("dnsServers");
                }
            }
            if (Optional.IsCollectionDefined(Subnets))
            {
                if (Subnets != null)
                {
                    writer.WritePropertyName("subnets"u8);
                    writer.WriteStartArray();
                    foreach (var item in Subnets)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("subnets");
                }
            }
        }

        MoverVirtualNetworkResourceSettings IJsonModel<MoverVirtualNetworkResourceSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverVirtualNetworkResourceSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoverVirtualNetworkResourceSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMoverVirtualNetworkResourceSettings(document.RootElement, options);
        }

        internal static MoverVirtualNetworkResourceSettings DeserializeMoverVirtualNetworkResourceSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            bool? enableDdosProtection = default;
            IList<string> addressSpace = default;
            IList<string> dnsServers = default;
            IList<SubnetResourceSettings> subnets = default;
            string resourceType = default;
            string targetResourceName = default;
            string targetResourceGroupName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        tags = null;
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("enableDdosProtection"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        enableDdosProtection = null;
                        continue;
                    }
                    enableDdosProtection = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("addressSpace"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        addressSpace = null;
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    addressSpace = array;
                    continue;
                }
                if (property.NameEquals("dnsServers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        dnsServers = null;
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    dnsServers = array;
                    continue;
                }
                if (property.NameEquals("subnets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        subnets = null;
                        continue;
                    }
                    List<SubnetResourceSettings> array = new List<SubnetResourceSettings>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SubnetResourceSettings.DeserializeSubnetResourceSettings(item, options));
                    }
                    subnets = array;
                    continue;
                }
                if (property.NameEquals("resourceType"u8))
                {
                    resourceType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetResourceName"u8))
                {
                    targetResourceName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetResourceGroupName"u8))
                {
                    targetResourceGroupName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MoverVirtualNetworkResourceSettings(
                resourceType,
                targetResourceName,
                targetResourceGroupName,
                serializedAdditionalRawData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                enableDdosProtection,
                addressSpace ?? new ChangeTrackingList<string>(),
                dnsServers ?? new ChangeTrackingList<string>(),
                subnets ?? new ChangeTrackingList<SubnetResourceSettings>());
        }

        BinaryData IPersistableModel<MoverVirtualNetworkResourceSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverVirtualNetworkResourceSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MoverVirtualNetworkResourceSettings)} does not support writing '{options.Format}' format.");
            }
        }

        MoverVirtualNetworkResourceSettings IPersistableModel<MoverVirtualNetworkResourceSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverVirtualNetworkResourceSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMoverVirtualNetworkResourceSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MoverVirtualNetworkResourceSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MoverVirtualNetworkResourceSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
