// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Gets or sets the target availability zone. </summary>
    public readonly partial struct MoverTargetAvailabilityZone : IEquatable<MoverTargetAvailabilityZone>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MoverTargetAvailabilityZone"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MoverTargetAvailabilityZone(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OneValue = "1";
        private const string TwoValue = "2";
        private const string ThreeValue = "3";
        private const string NAValue = "NA";

        /// <summary> 1. </summary>
        public static MoverTargetAvailabilityZone One { get; } = new MoverTargetAvailabilityZone(OneValue);
        /// <summary> 2. </summary>
        public static MoverTargetAvailabilityZone Two { get; } = new MoverTargetAvailabilityZone(TwoValue);
        /// <summary> 3. </summary>
        public static MoverTargetAvailabilityZone Three { get; } = new MoverTargetAvailabilityZone(ThreeValue);
        /// <summary> NA. </summary>
        public static MoverTargetAvailabilityZone NA { get; } = new MoverTargetAvailabilityZone(NAValue);
        /// <summary> Determines if two <see cref="MoverTargetAvailabilityZone"/> values are the same. </summary>
        public static bool operator ==(MoverTargetAvailabilityZone left, MoverTargetAvailabilityZone right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MoverTargetAvailabilityZone"/> values are not the same. </summary>
        public static bool operator !=(MoverTargetAvailabilityZone left, MoverTargetAvailabilityZone right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MoverTargetAvailabilityZone"/>. </summary>
        public static implicit operator MoverTargetAvailabilityZone(string value) => new MoverTargetAvailabilityZone(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MoverTargetAvailabilityZone other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MoverTargetAvailabilityZone other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
