// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines the move resource status. </summary>
    public partial class MoverResourceStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MoverResourceStatus"/>. </summary>
        internal MoverResourceStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MoverResourceStatus"/>. </summary>
        /// <param name="moveState"> Defines the MoveResource states. </param>
        /// <param name="jobStatus"> Defines the job status. </param>
        /// <param name="errors"> An error response from the azure resource mover service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MoverResourceStatus(MoverResourceMoveState? moveState, MoverResourceJobStatus jobStatus, MoveResourceError errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MoveState = moveState;
            JobStatus = jobStatus;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Defines the MoveResource states. </summary>
        public MoverResourceMoveState? MoveState { get; }
        /// <summary> Defines the job status. </summary>
        public MoverResourceJobStatus JobStatus { get; }
        /// <summary> An error response from the azure resource mover service. </summary>
        internal MoveResourceError Errors { get; }
        /// <summary> The move resource error body. </summary>
        public ResponseError ErrorsProperties
        {
            get => Errors?.Properties;
        }
    }
}
