// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines the move collection properties. </summary>
    public partial class MoverResourceSetProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MoverResourceSetProperties"/>. </summary>
        public MoverResourceSetProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MoverResourceSetProperties"/>. </summary>
        /// <param name="sourceLocation"> Gets or sets the source region. </param>
        /// <param name="targetLocation"> Gets or sets the target region. </param>
        /// <param name="moveLocation"> Gets or sets the move region which indicates the region where the VM Regional to Zonal move will be conducted. </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="version"> Gets or sets the version of move collection. </param>
        /// <param name="moveType"> Defines the MoveType. </param>
        /// <param name="errors"> Defines the move collection errors. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MoverResourceSetProperties(AzureLocation? sourceLocation, AzureLocation? targetLocation, AzureLocation? moveLocation, MoverProvisioningState? provisioningState, string version, MoveType? moveType, MoveCollectionPropertiesErrors errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceLocation = sourceLocation;
            TargetLocation = targetLocation;
            MoveLocation = moveLocation;
            ProvisioningState = provisioningState;
            Version = version;
            MoveType = moveType;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the source region. </summary>
        public AzureLocation? SourceLocation { get; set; }
        /// <summary> Gets or sets the target region. </summary>
        public AzureLocation? TargetLocation { get; set; }
        /// <summary> Gets or sets the move region which indicates the region where the VM Regional to Zonal move will be conducted. </summary>
        public AzureLocation? MoveLocation { get; set; }
        /// <summary> Defines the provisioning states. </summary>
        public MoverProvisioningState? ProvisioningState { get; }
        /// <summary> Gets or sets the version of move collection. </summary>
        public string Version { get; set; }
        /// <summary> Defines the MoveType. </summary>
        public MoveType? MoveType { get; set; }
        /// <summary> Defines the move collection errors. </summary>
        internal MoveCollectionPropertiesErrors Errors { get; }
        /// <summary> The move resource error body. </summary>
        public ResponseError ErrorsProperties
        {
            get => Errors?.Properties;
        }
    }
}
