// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines the resolution type. </summary>
    public readonly partial struct MoverResourceResolutionType : IEquatable<MoverResourceResolutionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MoverResourceResolutionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MoverResourceResolutionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";

        /// <summary> Manual. </summary>
        public static MoverResourceResolutionType Manual { get; } = new MoverResourceResolutionType(ManualValue);
        /// <summary> Automatic. </summary>
        public static MoverResourceResolutionType Automatic { get; } = new MoverResourceResolutionType(AutomaticValue);
        /// <summary> Determines if two <see cref="MoverResourceResolutionType"/> values are the same. </summary>
        public static bool operator ==(MoverResourceResolutionType left, MoverResourceResolutionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MoverResourceResolutionType"/> values are not the same. </summary>
        public static bool operator !=(MoverResourceResolutionType left, MoverResourceResolutionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MoverResourceResolutionType"/>. </summary>
        public static implicit operator MoverResourceResolutionType(string value) => new MoverResourceResolutionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MoverResourceResolutionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MoverResourceResolutionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
