// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    public partial class MoverResourcePropertiesMoveStatus : IUtf8JsonSerializable, IJsonModel<MoverResourcePropertiesMoveStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MoverResourcePropertiesMoveStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MoverResourcePropertiesMoveStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourcePropertiesMoveStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoverResourcePropertiesMoveStatus)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        MoverResourcePropertiesMoveStatus IJsonModel<MoverResourcePropertiesMoveStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourcePropertiesMoveStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoverResourcePropertiesMoveStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMoverResourcePropertiesMoveStatus(document.RootElement, options);
        }

        internal static MoverResourcePropertiesMoveStatus DeserializeMoverResourcePropertiesMoveStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MoverResourceMoveState? moveState = default;
            MoverResourceJobStatus jobStatus = default;
            MoveResourceError errors = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("moveState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    moveState = new MoverResourceMoveState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("jobStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        jobStatus = null;
                        continue;
                    }
                    jobStatus = MoverResourceJobStatus.DeserializeMoverResourceJobStatus(property.Value, options);
                    continue;
                }
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        errors = null;
                        continue;
                    }
                    errors = MoveResourceError.DeserializeMoveResourceError(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MoverResourcePropertiesMoveStatus(moveState, jobStatus, errors, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MoverResourcePropertiesMoveStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourcePropertiesMoveStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MoverResourcePropertiesMoveStatus)} does not support writing '{options.Format}' format.");
            }
        }

        MoverResourcePropertiesMoveStatus IPersistableModel<MoverResourcePropertiesMoveStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourcePropertiesMoveStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMoverResourcePropertiesMoveStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MoverResourcePropertiesMoveStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MoverResourcePropertiesMoveStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
