// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines the MoveResource states. </summary>
    public readonly partial struct MoverResourceMoveState : IEquatable<MoverResourceMoveState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MoverResourceMoveState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MoverResourceMoveState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AssignmentPendingValue = "AssignmentPending";
        private const string PreparePendingValue = "PreparePending";
        private const string PrepareInProgressValue = "PrepareInProgress";
        private const string PrepareFailedValue = "PrepareFailed";
        private const string MovePendingValue = "MovePending";
        private const string MoveInProgressValue = "MoveInProgress";
        private const string MoveFailedValue = "MoveFailed";
        private const string DiscardInProgressValue = "DiscardInProgress";
        private const string DiscardFailedValue = "DiscardFailed";
        private const string CommitPendingValue = "CommitPending";
        private const string CommitInProgressValue = "CommitInProgress";
        private const string CommitFailedValue = "CommitFailed";
        private const string CommittedValue = "Committed";
        private const string DeleteSourcePendingValue = "DeleteSourcePending";
        private const string ResourceMoveCompletedValue = "ResourceMoveCompleted";

        /// <summary> AssignmentPending. </summary>
        public static MoverResourceMoveState AssignmentPending { get; } = new MoverResourceMoveState(AssignmentPendingValue);
        /// <summary> PreparePending. </summary>
        public static MoverResourceMoveState PreparePending { get; } = new MoverResourceMoveState(PreparePendingValue);
        /// <summary> PrepareInProgress. </summary>
        public static MoverResourceMoveState PrepareInProgress { get; } = new MoverResourceMoveState(PrepareInProgressValue);
        /// <summary> PrepareFailed. </summary>
        public static MoverResourceMoveState PrepareFailed { get; } = new MoverResourceMoveState(PrepareFailedValue);
        /// <summary> MovePending. </summary>
        public static MoverResourceMoveState MovePending { get; } = new MoverResourceMoveState(MovePendingValue);
        /// <summary> MoveInProgress. </summary>
        public static MoverResourceMoveState MoveInProgress { get; } = new MoverResourceMoveState(MoveInProgressValue);
        /// <summary> MoveFailed. </summary>
        public static MoverResourceMoveState MoveFailed { get; } = new MoverResourceMoveState(MoveFailedValue);
        /// <summary> DiscardInProgress. </summary>
        public static MoverResourceMoveState DiscardInProgress { get; } = new MoverResourceMoveState(DiscardInProgressValue);
        /// <summary> DiscardFailed. </summary>
        public static MoverResourceMoveState DiscardFailed { get; } = new MoverResourceMoveState(DiscardFailedValue);
        /// <summary> CommitPending. </summary>
        public static MoverResourceMoveState CommitPending { get; } = new MoverResourceMoveState(CommitPendingValue);
        /// <summary> CommitInProgress. </summary>
        public static MoverResourceMoveState CommitInProgress { get; } = new MoverResourceMoveState(CommitInProgressValue);
        /// <summary> CommitFailed. </summary>
        public static MoverResourceMoveState CommitFailed { get; } = new MoverResourceMoveState(CommitFailedValue);
        /// <summary> Committed. </summary>
        public static MoverResourceMoveState Committed { get; } = new MoverResourceMoveState(CommittedValue);
        /// <summary> DeleteSourcePending. </summary>
        public static MoverResourceMoveState DeleteSourcePending { get; } = new MoverResourceMoveState(DeleteSourcePendingValue);
        /// <summary> ResourceMoveCompleted. </summary>
        public static MoverResourceMoveState ResourceMoveCompleted { get; } = new MoverResourceMoveState(ResourceMoveCompletedValue);
        /// <summary> Determines if two <see cref="MoverResourceMoveState"/> values are the same. </summary>
        public static bool operator ==(MoverResourceMoveState left, MoverResourceMoveState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MoverResourceMoveState"/> values are not the same. </summary>
        public static bool operator !=(MoverResourceMoveState left, MoverResourceMoveState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MoverResourceMoveState"/>. </summary>
        public static implicit operator MoverResourceMoveState(string value) => new MoverResourceMoveState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MoverResourceMoveState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MoverResourceMoveState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
