// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines the dependency of the move resource. </summary>
    public partial class MoverResourceDependency
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MoverResourceDependency"/>. </summary>
        internal MoverResourceDependency()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MoverResourceDependency"/>. </summary>
        /// <param name="id"> Gets the source ARM ID of the dependent resource. </param>
        /// <param name="resolutionStatus"> Gets the dependency resolution status. </param>
        /// <param name="resolutionType"> Defines the resolution type. </param>
        /// <param name="dependencyType"> Defines the dependency type. </param>
        /// <param name="manualResolution"> Defines the properties for manual resolution. </param>
        /// <param name="automaticResolution"> Defines the properties for automatic resolution. </param>
        /// <param name="isDependencyOptional"> Gets or sets a value indicating whether the dependency is optional. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MoverResourceDependency(ResourceIdentifier id, string resolutionStatus, MoverResourceResolutionType? resolutionType, MoverDependencyType? dependencyType, ManualResolutionProperties manualResolution, AutomaticResolutionProperties automaticResolution, string isDependencyOptional, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            ResolutionStatus = resolutionStatus;
            ResolutionType = resolutionType;
            DependencyType = dependencyType;
            ManualResolution = manualResolution;
            AutomaticResolution = automaticResolution;
            IsDependencyOptional = isDependencyOptional;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the source ARM ID of the dependent resource. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> Gets the dependency resolution status. </summary>
        public string ResolutionStatus { get; }
        /// <summary> Defines the resolution type. </summary>
        public MoverResourceResolutionType? ResolutionType { get; }
        /// <summary> Defines the dependency type. </summary>
        public MoverDependencyType? DependencyType { get; }
        /// <summary> Defines the properties for manual resolution. </summary>
        internal ManualResolutionProperties ManualResolution { get; }
        /// <summary> Gets or sets the target resource ARM ID of the dependent resource if the resource type is Manual. </summary>
        public ResourceIdentifier ManualResolutionTargetId
        {
            get => ManualResolution?.TargetId;
        }

        /// <summary> Defines the properties for automatic resolution. </summary>
        internal AutomaticResolutionProperties AutomaticResolution { get; }
        /// <summary>
        /// Gets the MoveResource ARM ID of
        /// the dependent resource if the resolution type is Automatic.
        /// </summary>
        public ResourceIdentifier AutomaticResolutionResourceId
        {
            get => AutomaticResolution?.ResourceId;
        }

        /// <summary> Gets or sets a value indicating whether the dependency is optional. </summary>
        public string IsDependencyOptional { get; }
    }
}
